"Filed out from Dolphin Smalltalk/Version 2.1"!

DarkLocation subclass: #SecretCanyon
	instanceVariableNames: 'enteredFromLocation'
	classVariableNames: ''
	poolDictionaries: ''!

SecretCanyon class instanceVariableNames: ''!

SecretCanyon comment: ''!

!SecretCanyon categoriesForClass!No category! !

!SecretCanyon methodsFor!

add: anObject
	| response |

	response := super add: anObject.

	"If the bird is dropped and the dragon is present we remove the bird and
	provide a nice little message"

	self world notNil ifTrue: [
		(anObject = self world bird) & (self contains: self world dragon)
			ifTrue: [
				self remove: anObject.
				^Response text: 'The little bird attacks the green dragon, and in an astounding ',
							'flurry gets burnt to a cinder.  The ashes blow away.' ] ].

	"If the mouse is dropped and the dragon is present we remove the dragon and
	provide a nice little message."

	self world notNil ifTrue: [
		(anObject = self world mouse) & (self contains: self world dragon)
			ifTrue: [
				self remove: self world dragon.
				^Response text: 'The dragon leaps up, screams in terror, and lumbers off down ',
							'the passageway.  (How''d you know dragons are scared of mice?)' ] ].
	^response!

enteredFromLocation
	"Answer the value of the receiver's instance variable enteredFromLocation.
	This method was automatically generated, but may be modified."

	^enteredFromLocation!

enteredFromLocation: anObject
	"Set the value of the receiver's instance variable enteredFromLocation to anObject.
	This method was automatically generated, but may be modified."

	enteredFromLocation := anObject!

receiveActor: anActor
	self enteredFromLocation: anActor location.
	^super receiveActor: anActor! !

!SecretCanyon categoriesFor: #add:!no category! !
!SecretCanyon categoriesFor: #enteredFromLocation!accessing! !
!SecretCanyon categoriesFor: #enteredFromLocation:!accessing! !
!SecretCanyon categoriesFor: #receiveActor:!no category! !

