"Filed out from Dolphin Smalltalk/Version 2.1"!

DarkLocation subclass: #HallOfMountainKing
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''!

HallOfMountainKing class instanceVariableNames: ''!

HallOfMountainKing comment: ''!

!HallOfMountainKing categoriesForClass!No category! !

!HallOfMountainKing methodsFor!

add: anObject
	"If the bird is dropped and the snake is present we remove the snake and
	provide a nice little message"

	| response |

	response := super add: anObject.

	self world notNil ifTrue: [
		(anObject = self world bird) & (self contains: self world snake)
			ifTrue: [
				self remove: self world snake.
				^Response text: 'The little bird attacks the green snake, and in an ',
							'astounding flurry drives the snake away.' ] ].
	^response!

allowTravelBy: anActor through: aConnection
	"If the snake is present the adventurer can't go in certain directions"

	(self contains: anActor world snake)
		ifTrue: [ #('north' 'left' 'south' 'right' 'west' 'forward') do: [ :each |
				(aConnection hasSynonym: each) ifTrue: [ ^false ] ] ].
	^true!

travelFailureReasonFor: anActor through: aConnection
	(self contains: anActor world snake)
		ifTrue: [ #('north' 'left' 'south' 'right' 'west' 'forward') do: [ :each |
				(aConnection hasSynonym: each) ifTrue: [ ^'You can''t get past the snake' ] ] ]
		ifFalse: [ ^'' ]! !

!HallOfMountainKing categoriesFor: #add:!no category! !
!HallOfMountainKing categoriesFor: #allowTravelBy:through:!no category! !
!HallOfMountainKing categoriesFor: #travelFailureReasonFor:through:!no category! !

