"Filed out from Dolphin Smalltalk/Version 2.1"!

SimpleActor subclass: #ColossalCaveActor
	instanceVariableNames: 'feeSequence fieSequence foeSequence'
	classVariableNames: ''
	poolDictionaries: ''!

ColossalCaveActor class instanceVariableNames: ''!

ColossalCaveActor comment: ''!

!ColossalCaveActor categoriesForClass!No category! !

!ColossalCaveActor methodsFor!

drop: anOrderedCollection
	| matchingObjects |

	matchingObjects := self contentsLike: (anOrderedCollection at: 1).

	"Only drop the vase on the pillow"

	matchingObjects size = 1 ifTrue: [
		(matchingObjects at: 1) == self world vase ifTrue: [
			(self location contains: self world pillow)
				ifTrue: [
					self remove: self world vase.
					self world pillow add: self world vase.
					self location == self world building ifTrue: [
						self accumulatePoints: self world vase ].
					^Response text: 'OK' ] 
				ifFalse: [
					self remove: self world vase.
					self location
						longDescription: (self location basicLongDescription,
										'  The floor is littered with worthless shards of pottery.');
						shortDescription: (self location basicShortDescription,
										'  There are some pieces of broken pottery on the floor.').
					^Response text: 'The ming vase drops with a delicate crash.' ] ].

		"If dropping a treasure for the troll, the troll takes it and goes elsewhere"

		(self location contains: self world troll) & ((matchingObjects at: 1) treasure)
			ifTrue: [
				self remove: (matchingObjects at: 1).
				self location remove: self world troll.
				self world troll longDescriptionSeen: false.
				self location == self world swChasm ifTrue: [ self world neChasm add: self world troll ].
				^Response text: 'The troll catches your treasure and scurries away out of sight.' ].

		"If dropping the bear, change its description"

		((matchingObjects at: 1) == self world docileBear)
			ifTrue: [ self world docileBear
						longDescription: 'There is a very large, tame bear here.';
						shortDescription: 'There is a very large, tame bear here.' ].

		"If dropping the bear in front of the troll, lose the troll"

		((matchingObjects at: 1) == self world docileBear) & (self location contains: self world troll)
			ifTrue: [
				self remove: (matchingObjects at: 1).
				self location add: (matchingObjects at: 1).
				self location remove: self world troll.
				^Response text: 'The bear lumbers toward the troll, who lets out a ',
							'startled shriek and scurries away.  The bear soon gives ',
							'up pursuit and wanders back.' ].

		"If dropping food in front of the ferocious bear replace him with the docile bear"

		((matchingObjects at: 1) == self world food) & (self location contains: self world ferociousBear)
			ifTrue: [
				self location remove: self world ferociousBear.
				self location add: self world docileBear.
				self remove: self world food.
				^Response text: 'The bear eagerly wolfs down your food, after which he seems ',
							'to calm down considerably, and even becomes rather friendly.' ].

		"Count up points earned"

		(self location == self world building) & ((matchingObjects at: 1) ~~ self world magazine) ifTrue: [
			self accumulatePoints: (matchingObjects at: 1) ].

		"Player gets one point for dropping magazines at Witt's End"

		(((matchingObjects at: 1) == self world magazine) & (self location == self world wittsEnd))
			ifTrue: [ self accumulatePoints: self world magazine ] ].

	^super drop: anOrderedCollection!

empty: anOrderedCollection
	self location = self world westPit
		ifTrue: [ ^self waterPlant: anOrderedCollection ].

	(self location == self world giantPassage)
		ifTrue: [ ^self oilDoor: anOrderedCollection ].

	^super empty: anOrderedCollection!

fee: anOrderedCollection
	anOrderedCollection size = 0
		ifTrue: [ self feeSequence: self sequence.  ^Response text: 'OK' ]
		ifFalse: [ ^Response text: 'Huh?' ]!

feeSequence
	"Answer the value of the receiver's instance variable feeSequence.
	This method was automatically generated, but may be modified."

	^feeSequence!

feeSequence: anObject
	"Set the value of the receiver's instance variable feeSequence to anObject.
	This method was automatically generated, but may be modified."

	feeSequence := anObject!

fie: anOrderedCollection
	anOrderedCollection size = 0
		ifTrue: [
			self feeSequence = (self sequence -1)
				ifTrue: [ self fieSequence: self sequence ]
				ifFalse: [ self fieSequence: 0 ].
			^Response text: 'OK' ]
		ifFalse: [ ^Response text: 'Huh?' ]!

fieSequence
	"Answer the value of the receiver's instance variable fieSequence.
	This method was automatically generated, but may be modified."

	^fieSequence!

fieSequence: anObject
	"Set the value of the receiver's instance variable fieSequence to anObject.
	This method was automatically generated, but may be modified."

	fieSequence := anObject!

fill: anOrderedCollection
	| matchingObjects |

	matchingObjects := self contentsLike: (anOrderedCollection at: 1).
	((matchingObjects size = 1) and: [ (matchingObjects at: 1) == self world vase ]) ifTrue: [
		self location hasWater
			ifTrue: [ "Don't *ever* put water into the vase"
				self remove: self world vase.
				self location
					longDescription: (self location basicLongDescription,
									'  The floor is littered with worthless shards of pottery.');
					shortDescription: (self location basicShortDescription,
									'  There are some pieces of broken pottery on the floor.').
				^Response text: 'The sudden change in temperature has delicately shattered the vase.' ].

		self location hasOil
			ifTrue: [ (matchingObjects at: 1) add: self world oil.
					^Response text: 'OK' ] ].

	^super fill: anOrderedCollection!

foe: anOrderedCollection
	anOrderedCollection size = 0
		ifTrue: [
			self fieSequence = (self sequence -1)
				ifTrue: [ self foeSequence: self sequence ]
				ifFalse: [ self foeSequence: 0 ].
			^Response text: 'OK' ]
		ifFalse: [ ^Response text: 'Huh?' ]!

foeSequence
	"Answer the value of the receiver's instance variable foeSequence.
	This method was automatically generated, but may be modified."

	^foeSequence!

foeSequence: anObject
	"Set the value of the receiver's instance variable foeSequence to anObject.
	This method was automatically generated, but may be modified."

	foeSequence := anObject!

foo: anOrderedCollection
	anOrderedCollection size = 0
		ifTrue: [
			self foeSequence = (self sequence -1)
				ifTrue: [ (self contains: self world eggs)
						ifTrue: [ self remove: self world eggs.
							     self world giantRoom add: self world eggs.
							     ^Response text: 'The golden eggs have vanished!!' ]
						ifFalse: [ ^Response text: 'Nothing happens' ] ].
			^Response text: 'OK' ]
		ifFalse: [ ^Response text: 'Huh?' ]!

get: anOrderedCollection
	| matchingObjects |

	matchingObjects := self location contentsLike: (anOrderedCollection at: 1).

	matchingObjects size > 0 ifTrue: [
		"Special processing if trying to get the bird"

		(matchingObjects at: 1) = self world bird
			ifTrue: [ ^self getBird: matchingObjects ].

		"Can't get the rug if the dragon is present"

		((matchingObjects at: 1) = self world rug) & (self location contains: self world dragon)
			ifTrue: [ ^Response text: 'The dragon seems very comfortable on the rug and doesn''t want to get up.' ].

		"If getting the bear, change its description"

		((matchingObjects at: 1) == self world docileBear)
			ifTrue: [ self world docileBear
						longDescription: 'You are being followed by a very large, tame bear.';
						shortDescription: 'You are being followed by a very large, tame bear.' ].

		"Can't get the chain if the bear hasn't been fed"

		((matchingObjects at: 1) == self world chain) ifTrue: [
			(self location contains: self world ferociousBear)
				ifTrue: [ ^Response text: 'There is no way to get past the bear to unlock the chain, which ',
									'is probably just as well.' ].

			"Can't get the chain if it's locked"

			self world chain locked ifTrue: [ ^Response text: 'The chain is still locked firmly to the wall.' ] ] ].

	^super get: anOrderedCollection!

getBird: matchingObjects
	"Private - can't get the bird unless you don't have the rod, and you do have the cage."

	(self contains: self world rod)
		ifTrue: [ ^Response text: 'The bird was unafraid when you entered, but as ',
						    'you approach it becomes disturbed and you ',
						    'cannot catch it' ]
		ifFalse: [ (self contains: self world cage)
					ifTrue: [ self location remove: (matchingObjects at: 1).
							self world cage add: (matchingObjects at: 1).
							^Response text: 'OK' ]
					ifFalse: [ ^Response text: 'You could catch the bird, but you cannot carry it.' ] ]!

go: anOrderedCollection
	| connections |

	"When in the west pit in the TwoPit room you can only 'climb' if the plant has grown enough"

	(self location == self world westPit) & ((anOrderedCollection at: 1) = 'climb') & (self world plant state ~= 3)
		ifTrue: [ ^Response chooseFrom: #('There''s no exit in that direction'
						'You can''t go that way'
						'You might be able to do that if you had a pickaxe'
						'Huh?') ].

	"At Y2 you can't get out by saying 'plover' if you're carrying the emerald"

	(self location == self world y2) & (self contains: self world emerald) & ((anOrderedCollection at: 1) = 'plover')
		ifTrue: [ ^Response text: 'You can''t go that way' ].

	"At the alcove you can't go into the plover room if you're carrying anything except the emerald"

	(self location == self world alcove) &
			((self contents size > 0) | ((self contents size = 1) & ((self contents at: 1) ~= self world emerald))) &
			(#('east' 'passage') anySatisfy: [ :each | each = (anOrderedCollection at: 1) ])
		ifTrue: [ ^Response text: 'Something you''re carrying won''t fit through the tunnel with ',
						    'you.  You''d best take inventory and drop something.' ].

	"In the secret canyon you can only go back the way you came if the dragon is present"

	(self location == self world secretCanyon) ifTrue: [
		connections := self location connectionsTo: (anOrderedCollection at: 1).
		(connections at: 1) destination ~= self enteredFromLocation ifTrue: [
			^Response text: 'The dragon looks rather nasty.  You''d best not try to get by.' ] ].

	"If at the chasm, the troll won't let you cross the bridge"

	((self location == self world swChasm) | (self location == self world neChasm)) &
			(self location contains: self world troll) ifTrue: [
		^Response text: 'The troll refuses to let you cross.' ].

	^super go: anOrderedCollection!

initialize
	super initialize.

	self
		feeSequence: 0;
		fieSequence: 0;
		foeSequence: 0!

oilDoor: anOrderedCollection
	"Private"
	| matchingObjects response |

	matchingObjects := self contentsLike: (anOrderedCollection at: 1).
	matchingObjects size = 0
		ifTrue: [ ^Response text: 'I don''t see a ', (anOrderedCollection at: 1), ' here.' ].
	matchingObjects size > 1
		ifTrue: [ ^Response text: 'Could you be a bit more specific?' ].

	response := Response text: 'OK'.

	(matchingObjects at: 1) contents do: [ :each |
		each ~= self world water & (each ~= self world oil)
			ifTrue: [ self location add: each ]
			ifFalse: [ 
				each = self world oil
					ifTrue: [ self world door locked: false ] ] ].

	(matchingObjects at: 1) contents removeAll: (matchingObjects at: 1) contents.
	^response!

open: anOrderedCollection
	"'open' usually means 'open a door'.  However, the player MAY want to try opening the
	clam/oyster, in which case they'd better have the trident."

	| matchingObjects response |

	matchingObjects := (self contentsLike: (anOrderedCollection at: 1)),
					(self location contentsLike: (anOrderedCollection at: 1)).
	matchingObjects size ~= 1 ifTrue: [ ^super open: anOrderedCollection ].

	(matchingObjects at: 1) == self world clam ifFalse: [ ^super open: anOrderedCollection ].

	"OK, we're trying to open the clam.  So *does* the actor have the trident?"

	(self contains: self world trident) ifFalse: [ ^Response text: 'Oh?  How?' ].

	"If the pearl has never been seen before it'll be contained by the current world.  If so move it to the
	 cul-de-sac and issue an appropriate message."

	(self world contains: self world pearl)
		ifTrue: [
			self world remove: self world pearl.
			self world culDeSac add: self world pearl.
			^Response text: 'A glistening pearl falls out of the oyster and rolls away' ]
		ifFalse: [ ^Response text: 'OK' ]!

unlock: anOrderedCollection
	"'unlock' usually means 'unlock a door'.  However, the player MAY want to unlock the
	chain, in which case they'd better have the keys."

	| matchingObjects response |

	matchingObjects := (self contentsLike: (anOrderedCollection at: 1)),
					(self location contentsLike: (anOrderedCollection at: 1)).
	matchingObjects size ~= 1 ifTrue: [ ^super unlock: anOrderedCollection ].

	(matchingObjects at: 1) == self world chain ifFalse: [ ^super unlock: anOrderedCollection ].

	"OK, we're trying to unlock the chain.  So *does* the actor have the keys?"

	(self location contains: self world ferociousBear)
		ifTrue: [ ^Response text: 'There is no way to get past the bear to unlock the chain, which ',
						    'is probably just as well.' ].

	(self contains: self world keys) ifFalse: [ ^Response text: 'You have nothing you can use to unlock the chain.' ].

	"OK, unlock it"

	self world chain locked: false.
	^Response text: 'The chain is now unlocked.'!

waterPlant: anOrderedCollection
	"Private"
	| matchingObjects response |

	matchingObjects := self contentsLike: (anOrderedCollection at: 1).
	matchingObjects size = 0
		ifTrue: [ ^Response text: 'I don''t see a ', (anOrderedCollection at: 1), ' here.' ].
	matchingObjects size > 1
		ifTrue: [ ^Response text: 'Could you be a bit more specific?' ].

	response := Response text: 'OK'.

	(matchingObjects at: 1) contents do: [ :each |
		each ~= self world water & (each ~= self world oil)
			ifTrue: [ self location add: each ]
			ifFalse: [ 
				each = self world water
					ifTrue: [ response := Response text: (self world plant incrementState,
										self world plant longDescription) ]
					ifFalse: [ response := Response text: 'The plant indignantly shakes ',
										     'the oil off its leaves and ',
										     'asks: "Water?".' ] ] ].
	(matchingObjects at: 1) contents removeAll: (matchingObjects at: 1) contents.
	^response!

wave: aCollection
	| matchingObjects |

	matchingObjects := self contentsLike: (aCollection at: 1).
	matchingObjects size = 0 ifTrue: [ ^Response text: 'Huh?' ].
	matchingObjects size > 1 ifTrue: [ ^Response text: 'Could you be a bit more specific?' ].

	(matchingObjects at: 1) = self world rod & 
			((self location = self world eastBankOfFissure) | (self location = self world westBankOfFissure))
		ifTrue: [
			"Flop the state of the bridge"

			self world bridge open
				ifTrue: [ self world bridge open: false. ^Response text: 'The bridge has vanished!!' ]
				ifFalse: [ self world bridge open: true. ^Response text: self world bridge openDescription ] ].

	((matchingObjects at: 1) = self world trident) &
			((self location contains: self world clam) | (self contains: self world clam))
		ifTrue: [ self world clam flipFlop. ^Response text: 'OK' ].

	^super wave: aCollection! !

!ColossalCaveActor categoriesFor: #drop:!no category! !
!ColossalCaveActor categoriesFor: #empty:!no category! !
!ColossalCaveActor categoriesFor: #fee:!no category! !
!ColossalCaveActor categoriesFor: #feeSequence!accessing! !
!ColossalCaveActor categoriesFor: #feeSequence:!accessing! !
!ColossalCaveActor categoriesFor: #fie:!no category! !
!ColossalCaveActor categoriesFor: #fieSequence!accessing! !
!ColossalCaveActor categoriesFor: #fieSequence:!accessing! !
!ColossalCaveActor categoriesFor: #fill:!no category! !
!ColossalCaveActor categoriesFor: #foe:!no category! !
!ColossalCaveActor categoriesFor: #foeSequence!accessing! !
!ColossalCaveActor categoriesFor: #foeSequence:!accessing! !
!ColossalCaveActor categoriesFor: #foo:!no category! !
!ColossalCaveActor categoriesFor: #get:!no category! !
!ColossalCaveActor categoriesFor: #getBird:!no category! !
!ColossalCaveActor categoriesFor: #go:!no category! !
!ColossalCaveActor categoriesFor: #initialize!no category! !
!ColossalCaveActor categoriesFor: #oilDoor:!no category! !
!ColossalCaveActor categoriesFor: #open:!no category! !
!ColossalCaveActor categoriesFor: #unlock:!no category! !
!ColossalCaveActor categoriesFor: #waterPlant:!no category! !
!ColossalCaveActor categoriesFor: #wave:!no category! !

!ColossalCaveActor class methodsFor!

defaultParserClass
	^ColossalCaveCommandParser! !

!ColossalCaveActor class categoriesFor: #defaultParserClass!no category! !

