"Filed out from Dolphin Smalltalk/Version 2.1"!

Shell subclass: #AdventureShell
	instanceVariableNames: 'inputTextPresenter displayTextPresenter'
	classVariableNames: ''
	poolDictionaries: ''!

AdventureShell class instanceVariableNames: ''!

AdventureShell comment: ''!

!AdventureShell categoriesForClass!No category! !

!AdventureShell methodsFor!

createComponents
	super createComponents.

	inputTextPresenter := self add: TextPresenter new name: 'inputText'.
	displayTextPresenter := self add: TextPresenter new name: 'displayText'.!

createSchematicWiring
	super createSchematicWiring.

	inputTextPresenter
		when: #keyPressed: send: #onKeyPressed: to: self.

	self model
		when: #responsesChanged send: #onResponsesChanged to: self.!

displayTextPresenter
	"Answer the value of the receiver's instance variable displayTextPresenter.
	This method was automatically generated, but may be modified."

	^displayTextPresenter!

displayTextPresenter: anObject
	"Set the value of the receiver's instance variable displayTextPresenter to anObject.
	This method was automatically generated, but may be modified."

	displayTextPresenter := anObject!

inputTextPresenter
	"Answer the value of the receiver's instance variable inputTextPresenter.
	This method was automatically generated, but may be modified."

	^inputTextPresenter!

inputTextPresenter: anObject
	"Set the value of the receiver's instance variable inputTextPresenter to anObject.
	This method was automatically generated, but may be modified."

	inputTextPresenter := anObject!

onExit
	self exit!

onHelp
	MessageBox new
		caption: 'Adventure Help';
		notify: self model helpString!

onKeyPressed: aKeyEvent
	aKeyEvent wParam asCharacter = Character cr	"Enter key pressed"
		ifTrue: [
			self model processCommand: self inputTextPresenter value.
			self model actor alive
				ifFalse: [ MessageBox warning: 'You seem to have died'.
						self inputTextPresenter view disable ] ]!

onResponsesChanged
	"Display the text of all the responses in the model"

	| text |

	self inputTextPresenter value: ''.
	text := String new initialize.
	self model responses do: [ :each | text := text, String lineDelimiter, each text ].
	self displayTextPresenter value: text.

	self displayTextPresenter view scrollVertical: self displayTextPresenter view lines!

onRestore
	self displayTextPresenter value: ''.
	self model restore!

onSave
	self model save!

onViewOpened
	super onViewOpened.
	self model processCommand: 'look'! !

!AdventureShell categoriesFor: #createComponents!no category! !
!AdventureShell categoriesFor: #createSchematicWiring!no category! !
!AdventureShell categoriesFor: #displayTextPresenter!accessing! !
!AdventureShell categoriesFor: #displayTextPresenter:!accessing! !
!AdventureShell categoriesFor: #inputTextPresenter!accessing! !
!AdventureShell categoriesFor: #inputTextPresenter:!accessing! !
!AdventureShell categoriesFor: #onExit!no category! !
!AdventureShell categoriesFor: #onHelp!no category! !
!AdventureShell categoriesFor: #onKeyPressed:!no category! !
!AdventureShell categoriesFor: #onResponsesChanged!no category! !
!AdventureShell categoriesFor: #onRestore!no category! !
!AdventureShell categoriesFor: #onSave!no category! !
!AdventureShell categoriesFor: #onViewOpened!no category! !

!AdventureShell class methodsFor!

defaultModel
	^TestWorld new initialize!

defaultView
	^'AdventureShell'! !

!AdventureShell class categoriesFor: #defaultModel!no category! !
!AdventureShell class categoriesFor: #defaultView!no category! !

