"Filed out from Dolphin Smalltalk/Version 2.1"!

Container subclass: #Actor
	instanceVariableNames: 'parser location world alive sequence points'
	classVariableNames: ''
	poolDictionaries: ''!

Actor class instanceVariableNames: ''!

Actor comment: 'An object which is capable of processing commands.'!

!Actor categoriesForClass!Adventure! !

!Actor methodsFor!

accumulatePoints: anItem
	self points: self points + anItem points.
	anItem points: 0!

alive
	"Answer the value of the receiver's instance variable alive.
	This method was automatically generated, but may be modified."

	^alive!

alive: anObject
	"Set the value of the receiver's instance variable alive to anObject.
	This method was automatically generated, but may be modified."

	alive := anObject!

close: aCollection
	| connections |

	connections := self location connectionsTo: (aCollection at: 1).
	connections size = 0 ifTrue: [ ^Response text: 'What are you trying to open?' ].

	connections size = 1 ifTrue: [
		(connections at: 1) closeable ifFalse: [ ^Response text: 'There''s no way to close that.' ].
		(connections at: 1) closed: true.
		^Response text: 'OK' ].

	"connections size > 1"

	^Response text: 'Could you be a bit more specific?'!

drop: anOrderedCollection
	| matchingObjects item |

	matchingObjects := self contentsLike: (anOrderedCollection at: 1).

	matchingObjects size = 0
		ifTrue: [ 
			self contents do: [ :each | 
				matchingObjects := each contentsLike: (anOrderedCollection at: 1).
				matchingObjects size = 1 ifTrue: [
					item := matchingObjects at: 1.
					each remove: item.
					self add: item.
					^self drop: anOrderedCollection ] ].
			^Response text: 'You don''t have a ', (anOrderedCollection at: 1) ].

	matchingObjects size = 1
		ifTrue: [
			self remove: (matchingObjects at: 1).
			^self location add: (matchingObjects at: 1) ].

	^Response text: 'Could you be a bit more specific?'!

empty: anOrderedCollection
	| matchingObjects response |

	matchingObjects := self contentsLike: (anOrderedCollection at: 1).
	matchingObjects size = 0
		ifTrue: [ ^Response text: 'I don''t see a ', (anOrderedCollection at: 1), ' here.' ].
	matchingObjects size > 1
		ifTrue: [ ^Response text: 'Could you be a bit more specific?' ].

	response := Response text: 'OK'.

	(matchingObjects at: 1) contents do: [ :each |
		each ~= self world water & (each ~= self world oil)
			ifTrue: [ self location add: each ]
			ifFalse: [ response := Response text: 'The ', each shortNounPhrase, ' splashes on the floor and evaporates.' ] ].

	(matchingObjects at: 1) contents removeAll: (matchingObjects at: 1) contents.
	^response!

execute: anAction
	"Execute the given action, answering an appropriate Response"

	^self perform: (anAction verb, ':') asSymbol with: anAction arguments!

fill: anOrderedCollection
	| matchingObjects |

	matchingObjects := self contentsLike: (anOrderedCollection at: 1).
	matchingObjects size = 0 ifTrue: [ ^Response text: 'I don''t see a ', (anOrderedCollection at: 1), ' here.' ].
	matchingObjects size > 1 ifTrue: [ ^Response text: 'Could you be a bit more specific?' ].

	self location hasWater
		ifTrue: [ (matchingObjects at: 1) add: self world water.
				^Response text: 'OK' ].

	self location hasOil
		ifTrue: [ (matchingObjects at: 1) add: self world oil.
				^Response text: 'OK' ].

	^Response text: 'I don''t see anything to fill the ', (anOrderedCollection at: 1), ' with.'!

get: anOrderedCollection
	| matchingObjects |

	matchingObjects := self location contentsLike: (anOrderedCollection at: 1).
	matchingObjects size = 0
		ifTrue: [ ^Response text: 'I don''t see a ', (anOrderedCollection at: 1), ' here.' ].
	matchingObjects size > 1
		ifTrue: [ ^Response text: 'Could you be a bit more specific?' ].

	(matchingObjects at: 1) movable
		ifTrue: [
			self location remove: (matchingObjects at: 1).
			^self add: (matchingObjects at: 1) ]
		ifFalse: [ ^Response text: 'You can''t seem to pick up the ', (matchingObjects at: 1) shortNounPhrase ]!

go: anOrderedCollection
	| connections responseText |

	connections := self location connectionsTo: (anOrderedCollection at: 1).
	connections do: [ :aConnection | 
		(aConnection open) & (aConnection unlocked) 
			ifTrue: [
				(self location allowTravelBy: self through: aConnection)
					ifTrue: [ ^Response text: (aConnection transport: self) ]
					ifFalse: [ ^Response text: (self location travelFailureReasonFor: self through: aConnection) ] ] ].

	"Couldn't find a way to go in the desired direction, so we need to determine an
	  appropriate response"

	connections do: [ :aConnection |
		aConnection locked & (aConnection lockedDescription ~= '')
				ifTrue: [ ^Response text: aConnection lockedDescription ].
		aConnection open not & (aConnection closedDescription ~= '')
				ifTrue: [ ^Response text: aConnection closedDescription ] ].

	^Response chooseFrom: #('There''s no exit in that direction'
						'You can''t go that way'
						'You might be able to do that if you had a pickaxe'
						'Huh?')!

help: anOrderedCollection
	^Response text: self world helpString!

initialize
	super initialize.
	self
		alive: true;
		inventoryable: false;
		sequence: 0;
		points: 0!

inventory
	^self inventory2ndPersonWithPrefix: 'You' suffix: ''!

inventory: aCollection
	^Response text: self inventory!

inventoryStringWithPrefix: aPrefixString suffix: aSuffixString
	^''!

light: aCollection
	| items wasLit |

	wasLit := self location lighted.
	items := self contentsLike: (aCollection at: 1).
	items size > 0
		ifTrue: [ (items at: 1) lightSource
				ifTrue: [ (items at: 1) lighted: true.
						wasLit
							ifTrue: [ ^Response text: 'OK' ]
							ifFalse: [ ^Response text: 'Ahh, much better...', String lineDelimiter, self location description ] ]
				ifFalse: [ ^Response chooseFrom: (Array with:'Nothing happens'
										   with: 'You can''t find the switch'
										   with: 'Huh?'
										   with: 'I''m game.  How?'
										   with: 'Let me guess - half the calories of our regular ',
												(items at: 1) nounPhrase, ' and all the great taste?') ] ]
		ifFalse: [ ^Response text: 'You don''t seem to have a ', (aCollection at: 1) ]!

location
	"Answer the value of the receiver's instance variable location.
	This method was automatically generated, but may be modified."

	^location!

location: aLocation
	location := aLocation!

look: anOrderedCollection
	"Answer a description of the current location"

	self location longDescriptionSeen: false.
	^Response text: self location description, String lineDelimiter, self location inventory!

open: aCollection
	| connections |

	connections := self location connectionsTo: (aCollection at: 1).
	connections size = 0 ifTrue: [ ^Response text: 'What are you trying to open?' ].

	connections size = 1 ifTrue: [
		(connections at: 1) locked ifTrue: [ ^Response text: 'It seems to be locked' ].

		(connections at: 1) open ifTrue: [ ^Response text: 'It''s already open' ].

		(connections at: 1) open: true.
		^Response text: 'OK' ].

	"connections size > 1"

	^Response text: 'Could you be a bit more specific?'!

parser
	"Answer the value of the receiver's instance variable parser.
	This method was automatically generated, but may be modified."

	parser isNil ifTrue: [ parser := self class defaultParserClass new initialize ].
	^parser!

points
	"Answer the value of the receiver's instance variable points.
	This method was automatically generated, but may be modified."

	^points!

points: anObject
	"Set the value of the receiver's instance variable points to anObject.
	This method was automatically generated, but may be modified."

	points := anObject!

processCommand: aString
	"Process the given command, answering a collection of Responses"

	| actions |

	self sequence: self sequence + 1.
	actions := self parser parse: aString withDirections: self location allDirections.
	^actions collect: [ :anAction | self execute: anAction ]!

respond: anOrderedCollection
	^Response text: (anOrderedCollection inject: '' into: [ :string :each | string := string, each ])!

say: anOrderedCollection
	^Response text: '''', (anOrderedCollection inject: '' into: [ :tot :each | tot, each ]), ''''!

score: anOrderedCollection
	^Response text: 'Current score: ', self points printString!

sequence
	"Answer the value of the receiver's instance variable sequence.
	This method was automatically generated, but may be modified."

	^sequence!

sequence: anObject
	"Set the value of the receiver's instance variable sequence to anObject.
	This method was automatically generated, but may be modified."

	sequence := anObject!

unlock: aCollection
	| connections |

	connections := self location connectionsTo: (aCollection at: 1).
	connections size = 0 ifTrue: [ ^Response text: 'What are you trying to unlock?' ].

	connections size = 1 ifTrue: [
		(connections at: 1) locked
			ifTrue: [
				(self contains: (connections at: 1) key)
					ifTrue: [
						(connections at: 1) locked: false.
						^Response text: (connections at: 1) description, String lineDelimiter, 'OK' ]
					ifFalse: [ ^Response text: 'You don''t seem to have the key' ] ]
			ifFalse: [ ^Response text: 'I don''t think it''s locked' ] ].

	"connections size > 1"

	^Response text: 'Could you be a bit more specific?'!

wave: aCollection
	| matchingObjects |

	matchingObjects := self contentsLike: (aCollection at: 1).
	matchingObjects size = 0 ifTrue: [ ^Response text: 'Huh?' ].
	matchingObjects size > 1 ifTrue: [ ^Response text: 'Could you be a bit more specific?' ].

	^Response chooseFrom: #('Swoosh!!'
						'Hey, that was neat!!  Do it again!!'
						'Nothing happens'
						'Is that your nose on the floor?')!

world
	"Answer the value of the receiver's instance variable world.
	This method was automatically generated, but may be modified."

	^world!

world: anObject
	"Set the value of the receiver's instance variable world to anObject.
	This method was automatically generated, but may be modified."

	world := anObject! !

!Actor categoriesFor: #accumulatePoints:!no category! !
!Actor categoriesFor: #alive!accessing! !
!Actor categoriesFor: #alive:!accessing! !
!Actor categoriesFor: #close:!no category! !
!Actor categoriesFor: #drop:!no category! !
!Actor categoriesFor: #empty:!no category! !
!Actor categoriesFor: #execute:!no category! !
!Actor categoriesFor: #fill:!no category! !
!Actor categoriesFor: #get:!no category! !
!Actor categoriesFor: #go:!no category! !
!Actor categoriesFor: #help:!no category! !
!Actor categoriesFor: #initialize!no category! !
!Actor categoriesFor: #inventory!no category! !
!Actor categoriesFor: #inventory:!no category! !
!Actor categoriesFor: #inventoryStringWithPrefix:suffix:!no category! !
!Actor categoriesFor: #light:!no category! !
!Actor categoriesFor: #location!accessing! !
!Actor categoriesFor: #location:!accessing! !
!Actor categoriesFor: #look:!no category! !
!Actor categoriesFor: #open:!no category! !
!Actor categoriesFor: #parser!accessing! !
!Actor categoriesFor: #points!accessing! !
!Actor categoriesFor: #points:!accessing! !
!Actor categoriesFor: #processCommand:!no category! !
!Actor categoriesFor: #respond:!no category! !
!Actor categoriesFor: #say:!no category! !
!Actor categoriesFor: #score:!no category! !
!Actor categoriesFor: #sequence!accessing! !
!Actor categoriesFor: #sequence:!accessing! !
!Actor categoriesFor: #unlock:!no category! !
!Actor categoriesFor: #wave:!no category! !
!Actor categoriesFor: #world!accessing! !
!Actor categoriesFor: #world:!accessing! !

!Actor class methodsFor!

defaultParserClass
	self subclassResponsibility! !

!Actor class categoriesFor: #defaultParserClass!no category! !

