TextDocs.NewDoc     Z
g   CWindowsLeft    WindowsTop d   Color    Flat  Locked  Controls  Org      BIER           3     Oberon10.Scn.Fnt     Syntax10.Scn.Fnt  ;                                                       9  (* ETH Oberon, Copyright 2001 ETH Zuerich Institut fuer Computersysteme, ETH Zentrum, CH-8092 Zuerich.
Refer to the "General ETH Oberon System Source License" contract available at: http://www.oberon.ethz.ch/ *)

MODULE V24; (** portable / source: Win32.V24.Mod *)	(* ejz   *)
	IMPORT S := SYSTEM, Kernel32, Kernel, Modules;

(** V24/RS232 serial communications interface. *)

	CONST
		(** port aliases (check with NumberOfPorts) *)
		COM1* = 0; COM2* = 1; COM3* = 2; COM4* = 3;
		(** parity *)
		ParNo* = 0; ParOdd* = 1; ParEven* = 2; ParMark* = 3; ParSpace* = 4;
		(** stop bits *)
		Stop1* = 1; Stop2* = 2; Stop1dot5* = 3;
		(** modem control - MC *)
		DTR* = 0; RTS* = 1; (** output *)
		Break* = 2; (** input/output *)
		DSR* = 3; CTS* = 4; RI* = 5; DCD* = 6; (** input *)

		Ok* = 0; PortInUse* = 1; NoSuchPort* = 2; WrongBPS* = 3; WrongData* = 4; WrongParity* = 5;
		WrongStop* = 6; Failed* = MAX(INTEGER);
		NPorts = 9;

		TXClear = 04H; RXClear = 08H;
		MAXDWORD = 0FFFFFFFFH;
		TxQueueSize = 1024;
		BufSize = TxQueueSize;
		EVCTS = 08H; EVDSR = 010H; EVRLSD = 020H; EVBreak = 040H; EVRing = 0100H;
		MSCTSON = 010H; MSDSRON = 020H; MSRINGON = 040H; MSRLSDON = 080H;
		CLRDTR = 6; CLRRTS = 4; SETDTR = 5; SETRTS = 3;

	TYPE
		DCB32 = RECORD (* DCB structure for Win32 *)
			DCBlength: LONGINT; (* sizeof(DCB) *)
			BaudRate: LONGINT; (* current baud rate*)
			flags: SET; (* bits in flags:
				DWORD fBinary: 1; (* binary mode, no EOF check *)
				DWORD fParity: 1; (* enable parity checking *)
				DWORD fOutxCtsFlow:1; (* CTS output flow control *)
				DWORD fOutxDsrFlow:1; (* DSR output flow control *)
				DWORD fDtrControl:2; (* DTR flow control type *)
				DWORD fDsrSensitivity:1; (* DSR sensitivity *)
				DWORD fTXContinueOnXoff:1; (* XOFF continues Tx *)
				DWORD fOutX: 1; (* XON/XOFF out flow control *)
				DWORD fInX: 1; (* XON/XOFF in flow control *)
				DWORD fErrorChar: 1; (* enable error replacement *)
				DWORD fNull: 1; (* enable null stripping *)
				DWORD fRtsControl:2; (* RTS flow control *)
				DWORD fAbortOnError:1; (* abort reads/writes on error *)
				DWORD fDummy2:17; (* reserved *) *)
			wReserved: INTEGER; (* not currently used *)
			XonLim: INTEGER; (* transmit XON threshold *)
			XoffLim: INTEGER; (* transmit XOFF threshold *)
			ByteSize: SHORTINT; (* number of bits/byte, 4-8 *)
			Parity: SHORTINT; (* 0-4=no,odd,even,mark,space *)
			StopBits: SHORTINT; (* 0, 1, 2 = 1, 1.5, 2 *)
			XonChar: CHAR; (* Tx and Rx XON character *)
			XoffChar: CHAR; (* Tx and Rx XOFF character *)
			ErrorChar: CHAR; (* error replacement character *)
			EofChar: CHAR; (* end of input character *)
			EvtChar: CHAR (* received event character *)
		END;
		COMMTIMEOUTS = RECORD (* COMMTIMEOUTS *)
			ReadInterval: LONGINT;
			ReadTotalMultiplier: LONGINT;
			ReadTotalConstant: LONGINT;
			WriteTotalMultiplier: LONGINT;
			WriteTotalConstant: LONGINT
		END;
		COMSTAT32 = RECORD (* COMSTAT for Win32 *)
			status: SET; (* fields in status:
				DWORD fCtsHold : 1; (* Tx waiting for CTS signal *)
				DWORD fDsrHold : 1; (* Tx waiting for DSR signal *)
				DWORD fRlsdHold : 1; (* Tx waiting for RLSD signal *)
				DWORD fXoffHold : 1; (* Tx waiting, XOFF char rec'd *)
				DWORD fXoffSent : 1; (* Tx waiting, XOFF char sent *)
				DWORD fEof : 1; (* EOF character sent *)
				DWORD fTxim : 1; (* character waiting for Tx *)
				DWORD fReserved : 25; (* reserved *) *)
			cbInQueue: LONGINT; (* bytes in input buffer *)		
			cbOutQueue: LONGINT (* bytes in output buffer *)
		END;

		Handle = POINTER TO RECORD (Kernel32.Object)
			recBuf: ARRAY BufSize OF S.BYTE;
			recBufSize, recBufPos: LONGINT;
			port: LONGINT
		END;

	VAR
		ClearCommBreak: PROCEDURE [WINAPI] (comDev: LONGINT): LONGINT;
		ClearCommError: PROCEDURE [WINAPI] (comDev, pErrors, pcst: LONGINT): LONGINT;
		EscapeCommFunction: PROCEDURE [WINAPI] (comDev, func: LONGINT): LONGINT;
		GetCommModemStatus: PROCEDURE [WINAPI] (comDev: LONGINT; VAR status: LONGINT): LONGINT;
		GetCommState: PROCEDURE [WINAPI] (comDev, pdcb: LONGINT): LONGINT;
		PurgeComm: PROCEDURE [WINAPI] (comDev, action: LONGINT): LONGINT;
		SetCommBreak: PROCEDURE [WINAPI] (comDev: LONGINT): LONGINT;
		SetCommMask: PROCEDURE [WINAPI] (comDev, mask: LONGINT): LONGINT;
		SetCommState: PROCEDURE [WINAPI] (comDev, pdcb: LONGINT): LONGINT;
		SetCommTimeouts: PROCEDURE [WINAPI] (comDev, pctmo: LONGINT): LONGINT;
		SetupComm: PROCEDURE [WINAPI] (comDev, NInQueue, NOutQueue: LONGINT): LONGINT;
		ports: ARRAY NPorts OF Handle;
		mod: Kernel32.HMODULE;

(** NumberOfPorts - Return the number of ports present *)
	PROCEDURE NumberOfPorts*(): LONGINT;
	BEGIN
		RETURN NPorts
	END NumberOfPorts;

	PROCEDURE *Finalize(handle: PTR);
	BEGIN
		WITH handle: Handle DO
			IF handle.handle # Kernel32.InvalidHandleValue THEN
				Kernel32.CloseHandle(handle.handle);
				handle.handle := Kernel32.InvalidHandleValue
			END;
			IF handle.port >= 0 THEN
				ports[handle.port] := NIL; handle.port := -1
			END
		END
	END Finalize;

	PROCEDURE LongOr(a, b: LONGINT): LONGINT;
	BEGIN
		RETURN S.VAL(LONGINT, S.VAL(SET, a) + S.VAL(SET, b))
	END LongOr;

(** Start - Open a serial port (numbered from 0). bps is the required bits per second.
	data is the number of bits per communication unit. parity is the parity mode (Par 
	values above). stop is the number of stop bits (Stop values above).
	res values:
		0	Ok
		1	port already in use
		2	no such port
		3	bad bps value
		4	bad data
		5	bad parity
		6	bad stop *)
	PROCEDURE Start*(port, bps, data, parity, stop: LONGINT; VAR res: LONGINT);
		VAR
			device: ARRAY 8 OF CHAR; handle: Handle;
			dcb32: DCB32; to: COMMTIMEOUTS;
			ret: LONGINT;
	BEGIN
		IF (port < 0) OR (port >= NPorts) THEN
			res := NoSuchPort
		ELSIF ports[port] = NIL THEN
			res := NoSuchPort;
			device := "COM0"; device[3] := CHR(port+ORD("1")); 
			NEW(ports[port]); handle := ports[port];
			handle.port := port; handle.handle := Kernel32.InvalidHandleValue;
			handle.recBufSize := 0; handle.recBufPos := 0;
			handle.handle := Kernel32.CreateFile(device, {Kernel32.GenericRead, Kernel32.GenericWrite}, {}, NIL, Kernel32.OpenExisting, {}, Kernel32.InvalidHandleValue);
			IF handle.handle # Kernel32.InvalidHandleValue THEN
				ret := GetCommState(handle.handle, S.ADR(dcb32));
				IF ret # 0 THEN
					ret := SetupComm(handle.handle, 1024, TxQueueSize);
					IF ret # 0 THEN
						dcb32.BaudRate := bps; res := Failed;
						IF (data >= 4) & (data <= 8) THEN
							dcb32.ByteSize := SHORT(SHORT(data))
						ELSE
							res := WrongData
						END;
						CASE stop OF
							Stop1: dcb32.StopBits := 0
							|Stop1dot5: dcb32.StopBits := 1
							|Stop2: dcb32.StopBits := 2
						ELSE
							res := WrongStop
						END;
						IF parity IN {ParNo, ParOdd, ParEven, ParMark, ParSpace} THEN
							dcb32.Parity := SHORT(SHORT(parity))
						ELSE
							res := WrongParity
						END;
						IF res = Failed THEN
							ret := SetCommState(handle.handle, S.ADR(dcb32));
							IF ret # 0 THEN
								ret := PurgeComm(handle.handle, LongOr(TXClear, RXClear));
								IF ret # 0 THEN
									to.ReadInterval := MAXDWORD;
									to.ReadTotalMultiplier := 0; to.ReadTotalConstant := 0;
									to.WriteTotalMultiplier := 0; to.WriteTotalConstant := 0;
									ret := SetCommTimeouts(handle.handle, S.ADR(to));
									IF ret # 0 THEN
										ret := LongOr(EVBreak, EVRing);
										ret := LongOr(ret, EVCTS);
										ret := LongOr(ret, EVDSR);
										ret := LongOr(ret, EVRLSD);
										ret := SetCommMask(handle.handle, ret);
										IF ret # 0 THEN
											Kernel.RegisterObject(handle, Finalize, TRUE);
											res := Ok
										END
									END
								END
							END
						END
					END
				END
			END;
			IF res # Ok THEN Finalize(handle) END
		ELSE
			res := PortInUse
		END
	END Start;

(** Stop - Close the specified port. Effect on Modem Control lines is undefined. *)
	PROCEDURE Stop*(port: LONGINT);
		VAR handle: Handle;
	BEGIN
		handle := ports[port];
		IF handle # NIL THEN
			IF handle.handle # Kernel32.InvalidHandleValue THEN
				Kernel32.CloseHandle(handle.handle);
				handle.handle := Kernel32.InvalidHandleValue
			END;
			IF handle.port >= 0 THEN handle.port := -1 END;
			ports[port] := NIL
		END
	END Stop;

	PROCEDURE AvailableH(handle: Handle): LONGINT;
		VAR errors: LONGINT; stat32: COMSTAT32;
	BEGIN
		ClearCommError(handle.handle, S.ADR(errors), S.ADR(stat32));
		RETURN stat32.cbInQueue
	END AvailableH;

(** Available - Return the number of bytes available in the specified port's buffer. *)
	PROCEDURE Available*(port: LONGINT): LONGINT;
		VAR handle: Handle;
	BEGIN
		handle := ports[port];
		IF (handle # NIL) & (handle.handle # Kernel32.InvalidHandleValue) THEN
			RETURN handle.recBufSize + AvailableH(handle)
		ELSE
			RETURN 0
		END
	END Available;

(** Send - Send a byte to the specified port. Waits until buffer space is available.
	res = Ok iff ok. *)
	PROCEDURE Send*(port: LONGINT; x: S.BYTE; VAR res: LONGINT);
		VAR handle: Handle; written: LONGINT; ret: Kernel32.BOOL;
	BEGIN
		handle := ports[port]; res := Failed;
		IF (handle # NIL) & (handle.handle # Kernel32.InvalidHandleValue) THEN
			ret := Kernel32.WriteFile(handle.handle, x, 1, written, NIL);
			IF (ret # Kernel32.False) & (written = 1) THEN res := Ok END
		END
	END Send;

(** SendBytes - Send n bytes to the specified port. Waits until buffer space is available.
	res = Ok iff all ok. *)
	PROCEDURE SendBytes*(port: LONGINT; VAR x: ARRAY OF S.BYTE; n: LONGINT; VAR res: LONGINT);
		VAR handle: Handle; written: LONGINT; ret: Kernel32.BOOL;
	BEGIN
		ASSERT(LEN(x) >= n);
		handle := ports[port]; res := Failed;
		IF (handle # NIL) & (handle.handle # Kernel32.InvalidHandleValue) THEN
			ret := Kernel32.WriteFile(handle.handle, x, n, written, NIL);
			IF (ret # Kernel32.False) & (written = n) THEN res := Ok END
		END
	END SendBytes;

(** Receive - Read one byte from the specified port. Waits until a byte is available.
	res = Ok iff ok. *)
	PROCEDURE Receive*(port: LONGINT; VAR x: S.BYTE; VAR res: LONGINT);
		VAR handle: Handle; l: LONGINT;
	BEGIN
		handle := ports[port]; res := Failed;
		IF (handle # NIL) & (handle.handle # Kernel32.InvalidHandleValue) THEN
			IF handle.recBufSize <= 0 THEN
				handle.recBufPos := 0; handle.recBufSize := 0;
				REPEAT
					l := AvailableH(handle)
				UNTIL l > 0;
				IF l > BufSize THEN l := BufSize END;
				Kernel32.ReadFile(handle.handle, handle.recBuf, l, handle.recBufSize, NIL)
			END;
			IF handle.recBufSize > 0 THEN
				x := handle.recBuf[handle.recBufPos];
				DEC(handle.recBufSize); INC(handle.recBufPos);
				res := Ok
			END
		END
	END Receive;

(** ReceiveBytes - Read n bytes from the specified port. Waits until n bytes are available.
	res = Ok iff ok. *)
	PROCEDURE ReceiveBytes*(port: LONGINT; VAR x: ARRAY OF S.BYTE; n: LONGINT; VAR res: LONGINT);
		VAR handle: Handle; i, l: LONGINT;
	BEGIN
		handle := ports[port]; res := Failed;
		IF (handle # NIL) & (handle.handle # Kernel32.InvalidHandleValue) THEN
			i := 0;
			WHILE n > 0 DO
				IF handle.recBufSize > 0 THEN
					IF handle.recBufSize > n THEN
						l := n
					ELSE
						l := handle.recBufSize
					END;
					S.MOVE(S.ADR(handle.recBuf[handle.recBufPos]), S.ADR(x[i]), l);
					DEC(n, l); INC(i, l)
				ELSE
					handle.recBufPos := 0; handle.recBufSize := 0;
					l := AvailableH(handle);
					IF l > BufSize THEN l := BufSize END;
					IF l > 0 THEN
						Kernel32.ReadFile(handle.handle, handle.recBuf, l, handle.recBufSize, NIL)
					END
				END
			END;
			IF n = 0 THEN res := Ok END
		END
	END ReceiveBytes;

(** ClearMC - Clear the specified Modem Control lines of the specified port. s may contain DTR, RTS & Break. *)
	PROCEDURE ClearMC*(port: LONGINT; s: SET);
		VAR handle: Handle;
	BEGIN
		handle := ports[port];
		IF (handle # NIL) & (handle.handle # Kernel32.InvalidHandleValue) THEN
			IF Break IN s THEN
				ClearCommBreak(handle.handle)
			END;
			IF DTR IN s THEN
				EscapeCommFunction(handle.handle, CLRDTR)
			END;
			IF RTS IN s THEN
				EscapeCommFunction(handle.handle, CLRRTS)
			END
		END
	END ClearMC;

	PROCEDURE Includes(flags, option: LONGINT): BOOLEAN;
		VAR fl, op: SET;
	BEGIN
		fl := S.VAL(SET, flags); op := S.VAL(SET, option);
		RETURN (op * fl) = op
	END Includes;

(** GetMC - Return the state of the specified Modem Control lines of the specified port. s contains the current state
		of DSR, CTS, RI, DCD & Break. *)
	PROCEDURE GetMC*(port: LONGINT; VAR s: SET);
		VAR handle: Handle; state: LONGINT;
	BEGIN
		handle := ports[port]; s:= {};
		IF (handle # NIL) & (handle.handle # Kernel32.InvalidHandleValue) THEN
			GetCommModemStatus(handle.handle, state);
			IF Includes(state, MSCTSON) THEN
				INCL(s, CTS)
			END;
			IF Includes(state, MSDSRON) THEN
				INCL(s, DSR)
			END;
			IF Includes(state, MSRINGON) THEN
				INCL(s, RI)
			END;
			IF Includes(state, MSRLSDON) THEN
				INCL(s, DCD)
			END
		END
	END GetMC;

(** SetMC - Set the specified Modem Control lines of the specified port. s may contain DTR, RTS & Break. *)
	PROCEDURE SetMC*(port: LONGINT; s: SET);
		VAR handle: Handle;
	BEGIN
		handle := ports[port];
		IF (handle # NIL) & (handle.handle # Kernel32.InvalidHandleValue) THEN
			IF Break IN s THEN
				SetCommBreak(handle.handle)
			END;
			IF DTR IN s THEN
				EscapeCommFunction(handle.handle, SETDTR)
			END;
			IF RTS IN s THEN
				EscapeCommFunction(handle.handle, SETRTS)
			END
		END	
	END SetMC;

	PROCEDURE *TermMod();
		VAR i: LONGINT;
	BEGIN
		FOR i := 0 TO NPorts-1 DO
			IF ports[i] # NIL THEN
				Finalize(ports[i]);
				ports[i] := NIL
			END
		END;
		IF mod # Kernel32.NULL THEN
			Kernel32.FreeLibrary(mod);
			mod := Kernel32.NULL
		END
	END TermMod;

	PROCEDURE Init();
		VAR i: LONGINT;
	BEGIN
		FOR i := 0 TO NPorts-1 DO
			ports[i] := NIL
		END;
		mod := Kernel32.LoadLibrary("Kernel32");
		Kernel32.GetProcAddress(mod, "ClearCommBreak", S.VAL(LONGINT, ClearCommBreak));
		Kernel32.GetProcAddress(mod, "ClearCommError", S.VAL(LONGINT, ClearCommError));
		Kernel32.GetProcAddress(mod, "EscapeCommFunction", S.VAL(LONGINT, EscapeCommFunction));
		Kernel32.GetProcAddress(mod, "GetCommModemStatus", S.VAL(LONGINT, GetCommModemStatus));
		Kernel32.GetProcAddress(mod, "GetCommState", S.VAL(LONGINT, GetCommState));
		Kernel32.GetProcAddress(mod, "PurgeComm", S.VAL(LONGINT, PurgeComm));
		Kernel32.GetProcAddress(mod, "SetCommBreak", S.VAL(LONGINT, SetCommBreak));
		Kernel32.GetProcAddress(mod, "SetCommMask", S.VAL(LONGINT, SetCommMask));
		Kernel32.GetProcAddress(mod, "SetCommState", S.VAL(LONGINT, SetCommState));
		Kernel32.GetProcAddress(mod, "SetCommTimeouts", S.VAL(LONGINT, SetCommTimeouts));
		Kernel32.GetProcAddress(mod, "SetupComm", S.VAL(LONGINT, SetupComm));
		Modules.InstallTermHandler(TermMod)
	END Init;

BEGIN
	Init()
END V24.
BIER.;  ?;   :    <       g 
     C  Syntax10.Scn.Fnt 07.05.2004  15:39:36  TimeStamps.New  