TextDocs.NewDoc     
 W   Syntax10.Scn.Fnt  /   Oberon10.Scn.Fnt           S         '   }(  (* Copyright (c) 1994 - 2000 Emil J. Zeller *)

 MODULE RegistryTools; (** non-portable / source: Win32.RegistryTools.Mod *)	(* ejz  *)
	IMPORT SYSTEM, Kernel, Kernel32, ADVAPI32, Registry, FileDir, Files, Strings, Texts, Oberon;

	VAR
		curPath: ARRAY 256 OF CHAR;
		W: Texts.Writer;
		R: Files.Rider;

	PROCEDURE WriteString(VAR R: Files.Rider; str: ARRAY OF CHAR; esc: BOOLEAN);
		VAR i: LONGINT;
	BEGIN
		i := 0;
		WHILE str[i] # 0X DO
			IF esc THEN
				IF str[i] = "\" THEN
					Files.Write(R, "\"); Files.Write(R, "\")
				ELSIF str[i] = '"' THEN
					Files.Write(R, "\"); Files.Write(R, '"')
				ELSE
					Files.Write(R, str[i])
				END
			ELSE
				Files.Write(R, str[i])
			END;
			INC(i)
		END
	END WriteString;

	PROCEDURE WriteLn(VAR R: Files.Rider);
	BEGIN
		Files.Write(R, Strings.CR); Files.Write(R, Strings.LF)
	END WriteLn;

	PROCEDURE ReadLine(VAR R: Files.Rider; VAR line: ARRAY OF CHAR);
		VAR
			i: LONGINT;
			ch: CHAR;
	BEGIN
		Files.Read(R, ch);
		WHILE ~R.eof & (ch <= " ") DO
			Files.Read(R, ch)
		END;
		i := 0;
		WHILE ~R.eof & (ch >= " ") DO
			line[i] := ch; INC(i);
			Files.Read(R, ch)
		END;
		line[i] := 0X
	END ReadLine;

	PROCEDURE GetFileDescription(VAR software: ARRAY OF CHAR);
		VAR
			file: ARRAY Kernel32.MaxPath OF CHAR;
			buf: POINTER TO ARRAY OF SYSTEM.BYTE;
			adr: Kernel32.ADDRESS; len: LONGINT; 
	BEGIN
		Kernel32.GetModuleFileName(Kernel.hInstance, file, Kernel32.MaxPath);
		len := ADVAPI32.GetFileVersionInfoSize(file, NIL); NEW(buf, len);
		ADVAPI32.GetFileVersionInfo(file, 0, len, buf^);
		ADVAPI32.VerQueryValue(buf^, "\StringFileInfo\040904e4\FileDescription", adr, len);
		IF len >= Kernel32.MaxPath THEN HALT(99) END;
		SYSTEM.MOVE(adr, SYSTEM.ADR(software), len);
		ADVAPI32.VerQueryValue(buf^, "\StringFileInfo\040904e4\FileVersion", adr, len)
	END GetFileDescription;

	PROCEDURE GetFileVersion(VAR version: ARRAY OF CHAR);
		VAR
			file: FileDir.FileName;
			buf: POINTER TO ARRAY OF SYSTEM.BYTE;
			ret, disp, len: LONGINT;
	BEGIN
		ret := Kernel32.GetModuleFileName(Kernel.hInstance, file, LEN(file));
		len := ADVAPI32.GetFileVersionInfoSize(file, disp);
		NEW(buf, len);
		ret := ADVAPI32.GetFileVersionInfo(file, disp, len, buf^);
		file := "\StringFileInfo\040904e4\FileVersion";
		ret := ADVAPI32.VerQueryValue(buf^, file, disp, len);
		IF ret # 0 THEN
			IF len >= LEN(version) THEN
				len := LEN(version)-1
			END;
			SYSTEM.MOVE(disp, SYSTEM.ADR(version[0]), len)
		ELSE
			HALT(99)
		END
	END GetFileVersion;

	PROCEDURE *EnumKeyValue(key, value: ARRAY OF CHAR);
	BEGIN
		IF key = "" THEN
			Files.Write(R, "@")
		ELSE
			Files.Write(R, 022X); WriteString(R, key, TRUE); Files.Write(R, 022X)
		END;
		Files.Write(R, "=");
		Files.Write(R, 022X); WriteString(R, value, TRUE); Files.Write(R, 022X);
		WriteLn(R)
	END EnumKeyValue;

	PROCEDURE WriteKeyValues();
	BEGIN
		WriteString(R, "[HKEY_CURRENT_USER\", FALSE);
		WriteString(R, curPath, FALSE); Files.Write(R, "]"); WriteLn(R);
		Registry.EnumerateKeyValue(Registry.CurrentUser, curPath, EnumKeyValue);
		WriteLn(R)
	END WriteKeyValues;

	PROCEDURE *EnumPath(path: ARRAY OF CHAR);
		VAR bakPath: ARRAY 256 OF CHAR;
	BEGIN
		COPY(curPath, bakPath);
		Strings.AppendCh(curPath, "\"); Strings.Append(curPath, path);
		WriteKeyValues();
		Registry.EnumeratePath(Registry.CurrentUser, curPath, EnumPath);
		COPY(bakPath, curPath)
	END EnumPath;

(** RegistryTools.Store [ \V version ] regfile
		Stores all entries in [HKEY_CURRENT_USER\Software\<software>\<version>] to regfile.

		Note: regfile is in regedit format, if you want to edit it with oberon use EditTools.OpenAscii
		to open it and EditTools.StoreAscii to store it.

		By default the registry of the currently running version is stored. To store entries of another
		version use the V option. e.g. RegistryTools.Store \V "Release 2.21" old.reg ~ *)
	PROCEDURE Store*;
		VAR
			S: Texts.Scanner;
			software, version: ARRAY 64 OF CHAR;
			F: Files.File;
	BEGIN
		GetFileDescription(software);
		GetFileVersion(version);
		Texts.OpenScanner(S, Oberon.Par.text, Oberon.Par.pos);
		Texts.Scan(S);
		WHILE (S.class = Texts.Char) & (S.c = Oberon.OptionChar) DO
			Texts.Scan(S);
			IF CAP(S.s[0]) = "S" THEN
				Texts.Scan(S); COPY(S.s, software)
			ELSIF CAP(S.s[0]) = "V" THEN
				Texts.Scan(S); COPY(S.s, version)
			END;
			Texts.Scan(S)
		END;
		IF S.class IN {Texts.Name, Texts.String} THEN
			Texts.WriteString(W, "RegistryTools.Store: ");
			Texts.WriteString(W, software);
			Texts.WriteString(W, ", ");
			Texts.WriteString(W, version);
			Texts.WriteString(W, " to ");
			Texts.WriteString(W, S.s);
			Texts.WriteLn(W); Texts.Append(Oberon.Log, W.buf);
			F := Files.New(S.s); Files.Set(R, F, 0);
			WriteString(R, "REGEDIT4", FALSE); WriteLn(R); WriteLn(R);
			COPY(Registry.oberonRoot, curPath);
			WriteKeyValues();
			Registry.EnumeratePath(Registry.CurrentUser, Registry.oberonRoot, EnumPath);
			Files.Register(F);
			Texts.WriteLn(W); Texts.Append(Oberon.Log, W.buf);
			Files.Set(R, NIL, 0)
		END
	END Store;

(** RegistryTools.Load [ \V version ] regfile
		Write the registry entires in regfile to [HKEY_CURRENT_USER\Software\<software>\<version>].

		Note: regfile is in regedit format, if you want to edit it with oberon use EditTools.OpenAscii
		to open it and EditTools.StoreAscii to store it.

		By default the registry of the currently running version is overwritten. To overwrite entries of 
		another version use the V option. e.g. RegistryTools.Load \V "Release 2.3" old.reg ~ *)
	PROCEDURE Load*;
		VAR
			S: Texts.Scanner;
			software, version: ARRAY 64 OF CHAR;
			section, name, value: ARRAY 256 OF CHAR;
			F: Files.File;
			R: Files.Rider;
			buf: ARRAY 256 OF CHAR;
			i, j: LONGINT;
	BEGIN
		GetFileDescription(software);
		GetFileVersion(version);
		Texts.OpenScanner(S, Oberon.Par.text, Oberon.Par.pos);
		Texts.Scan(S);
		WHILE (S.class = Texts.Char) & (S.c = Oberon.OptionChar) DO
			Texts.Scan(S);
			IF CAP(S.s[0]) = "S" THEN
				Texts.Scan(S); COPY(S.s, software)
			ELSIF CAP(S.s[0]) = "V" THEN
				Texts.Scan(S); COPY(S.s, version)
			END;
			Texts.Scan(S)
		END;
		IF S.class IN {Texts.Name, Texts.String} THEN
			Texts.WriteString(W, "RegistryTools.Load: ");
			Texts.WriteString(W, software);
			Texts.WriteString(W, ", ");
			Texts.WriteString(W, version);
			Texts.WriteString(W, " from ");
			Texts.WriteString(W, S.s);
			F := Files.Old(S.s); Files.Set(R, F, 0);
			ReadLine(R, buf); ASSERT(buf = "REGEDIT4", 101);
			ReadLine(R, buf); section := "";
			WHILE ~R.eof DO
				IF (buf[0] = "[") & Strings.Prefix("[HKEY_CURRENT_USER\Software\", buf) THEN
					i := 19; j := 0;
					WHILE buf[i] # "]" DO
						section[j] := buf[i];
						INC(j); INC(i)
					END;
					section[j] := 0X
				ELSIF (buf[0] = '"') OR (buf[0] = "@") THEN
					IF buf[0] = '"' THEN
						i := 1; j := 0;
						WHILE (buf[i] # 0X) & (buf[i] # '"') DO
							IF buf[i] = "\" THEN
								INC(i)
							END;
							name[j] := buf[i]; INC(j);
							INC(i)
						END;
						name[j] := 0X;
						ASSERT(buf[i] = '"', 103); INC(i)
					ELSE
						i := 1; name := ""
					END;
					ASSERT(buf[i] = "=", 104); INC(i);
					ASSERT(buf[i] = '"', 105); INC(i);
					j := 0;
					WHILE (buf[i] # 0X) & (buf[i] # '"') DO
						IF buf[i] = "\" THEN
							INC(i)
						END;
						value[j] := buf[i]; INC(j);
						INC(i)
					END;
					value[j] := 0X;
					Registry.SetKeyValue(Registry.CurrentUser, section, name, value);
					ASSERT(Registry.res = Registry.Done, 107)
				ELSE
					HALT(106)
				END;
				ReadLine(R, buf)
			END;
			Texts.WriteLn(W); Texts.Append(Oberon.Log, W.buf)
		END
	END Load;

(** RegistryTools.Delete \S Software \V version
		Deletes all keys & values in [HKEY_CURRENT_USER\Software\<software>\<version>]. *)
	PROCEDURE Delete*;
		VAR
			S: Texts.Scanner;
			software, version: ARRAY 64 OF CHAR;
			path: ARRAY 128 OF CHAR;
	BEGIN
		software := ""; version := "";
		Texts.OpenScanner(S, Oberon.Par.text, Oberon.Par.pos);
		Texts.Scan(S);
		WHILE (S.class = Texts.Char) & (S.c = Oberon.OptionChar) DO
			Texts.Scan(S);
			IF CAP(S.s[0]) = "S" THEN
				Texts.Scan(S); COPY(S.s, software)
			ELSIF CAP(S.s[0]) = "V" THEN
				Texts.Scan(S); COPY(S.s, version)
			END;
			Texts.Scan(S)
		END;
		IF (software # "") & (version # "") THEN
			Texts.WriteString(W, "RegistryTools.Delete Software\");
			Texts.WriteString(W, software); Texts.Write(W, "\"); Texts.WriteString(W, version);
			COPY("Software\", path); Strings.Append(path, software);
			Strings.AppendCh(path, "\"); Strings.Append(path, version);
			Registry.DeletePath(Registry.CurrentUser, path);
			IF Registry.res # Registry.Done THEN
				Texts.WriteString(W, " failed")
			ELSE
				Texts.WriteString(W, " done")
			END;
			Texts.WriteLn(W); Texts.Append(Oberon.Log, W.buf)
		END
	END Delete;

(** RegistryTools.Version
		Display version information for the currently running version. *)
	PROCEDURE Version*;
		VAR software, version: ARRAY 64 OF CHAR;
	BEGIN
		GetFileDescription(software);
		GetFileVersion(version);
		Texts.WriteString(W, "Software: "); Texts.WriteString(W, software); Texts.WriteLn(W);
		Texts.WriteString(W, "Version: "); Texts.WriteString(W, version);
		Texts.WriteLn(W); Texts.Append(Oberon.Log, W.buf)
	END Version;

(** RegistryTools.Convert unicoderegfile asciiregfile
	Convert a .reg file in unicode format (Windows 2000) to the old asciifile format
	(Windows 95, 98, NT). *)
	PROCEDURE Convert*;
		VAR S: Texts.Scanner; F, Fn: Files.File; R, Rn: Files.Rider; ch: CHAR;
	BEGIN
		Texts.OpenScanner(S, Oberon.Par.text, Oberon.Par.pos);
		Texts.Scan(S);
		IF S.class IN {Texts.Name, Texts.String} THEN
			F := Files.Old(S.s); Files.Set(R, F, 0);
			Texts.Scan(S);
			IF (F # NIL) & (S.class IN {Texts.Name, Texts.String}) THEN
				Fn := Files.New(S.s); Files.Set(Rn, Fn, 0);
				WriteString(Rn, "REGEDIT4", FALSE); WriteLn(Rn); WriteLn(Rn);
				Files.Read(R, ch);
				WHILE ~R.eof & (ch # "[") DO
					Files.Read(R, ch)
				END;
				WHILE ~R.eof DO
					IF ch # 0X THEN Files.Write(Rn, ch) END;
					Files.Read(R, ch)
				END;
				Files.Register(Fn)
			END
		END
	END Convert;

BEGIN
	Texts.OpenWriter(W)
END RegistryTools.

RegistryTools.Version

RegistryTools.Store xxx.reg

RegistryTools.Delete \S "ETH Oberon" \V "Release 2.3" ~

RegistryTools.Load xxx.reg

EditTools.OpenAscii ^
EditTools.StoreAscii *

escapes:
	\ -> \\
	" --> \"
	@ --> default (empty key)
BIERo)  )   )  -)    "         d      d
     C  <       g 
     C  Syntax10.Scn.Fnt 02.05.2000  13:26:24  TextGadgets.NewStyleProc TimeStamps.New  