TextDocs.NewDoc     Qg   CWindowsLeft .   WindowsTop `   Color    Flat  Locked  Controls  Org E   BIER           3     Oberon10.Scn.Fnt     Syntax10.Scn.Fnt  S         C        Syntax12.Scn.Fnt  O    
    F                7         (* ETH Oberon, Copyright 2001 ETH Zuerich Institut fuer Computersysteme, ETH Zentrum, CH-8092 Zuerich.
Refer to the "General ETH Oberon System Source License" contract available at: http://www.oberon.ethz.ch/ *)

MODULE Input; (** portable, except where noted / source: Win32.Input.Mod *)	(* ejz   *)
	IMPORT SYSTEM, Kernel32, User32, Displays, Display, Viewers;

(** Module Input is responsible for event timing, mouse and keyboard input. *)

	CONST
		TimeUnit* = 1000;	(** timer ticks per second (platform dependent). *)
		SHIFT* = 0; CTRL* = 1; ALT* = 2; (** constants for KeyState *)

	(** Returns the number of keystrokes in the keyboard input buffer. *)
	PROCEDURE Available*(): INTEGER;
	BEGIN
		Displays.FlushCharacterCache(Display.cur);
		RETURN SHORT(Displays.AvailChar())
	END Available;

	(** Read a character from the keyboard buffer. Blocks if no character is available. *)
	PROCEDURE Read*(VAR ch: CHAR);
	BEGIN
		Displays.FlushCharacterCache(Display.cur);
		Displays.ReadChar(ch)
	END Read;

	(** Write a character to the keyboard buffer. *)
	PROCEDURE Write*(ch: CHAR);	(** non-portable *)
	BEGIN
		Displays.FlushCharacterCache(Display.cur);
		Displays.WriteChar(Display.cur, ch)
	END Write;

	(** Return the state of the shift keys (SHIFT, CTRL or ALT). *)
	PROCEDURE KeyState*(VAR keys: SET);
	BEGIN
		Displays.FlushCharacterCache(Display.cur); keys := {};
		IF User32.GetAsyncKeyState(User32.VKShift) < 0 THEN INCL(keys, SHIFT) END;
		IF User32.GetAsyncKeyState(User32.VKControl) < 0 THEN INCL(keys, CTRL) END;
		IF User32.GetAsyncKeyState(User32.VKMenu) < 0 THEN INCL(keys, ALT) END
	END KeyState;

	(** Reads the current mouse position x, y and the key state of the mouse buttons (also called keys). The mouse buttons
		are numbered from the right to the left as 0, 1, 2 (i.e. 1 is the middle mouse button). For example, when the left and
		middle buttons are pressed, keys will be set to {1, 2}. *)
	PROCEDURE Mouse*(VAR keys: SET; VAR x, y: INTEGER);
		VAR win: Displays.Display;
	BEGIN
		win := Display.cur;
		Displays.FlushCharacterCache(win);
		IF (win # NIL) & (win IS Viewers.Window) THEN
			WITH win: Viewers.Window DO
				Kernel32.Sleep(0);
				keys := win.track.keys; x := SHORT(win.track.X); y := SHORT(win.track.Y)
			END
		ELSE
			keys := {}; x := 0; y := 0
		END
	END Mouse;

	(** Returns the elapsed number of timer ticks from Oberon (Windows) startup. *)
	PROCEDURE Time*(): LONGINT;
	BEGIN
		RETURN Kernel32.GetTickCount()
	END Time;

END Input.

(** Remarks:

Keyboard character codes correspond to the ASCII character set. Some other important codes are:

	SHIFT-BREAK	0ADX
	BREAK	0ACX
	F1, SETUP	0A4X
	F2, NEUTRALISE	0A5X
	F3, SCRL	0A6X
	F4, NOSCRL	0A7X
	UP ARROW	0C1X
	RIGHT ARROW	0C3X
	DOWN ARROW	0C2X
	LEFT ARROW	0C4X
	INSERT	0A0X
	DELETE	0A1X
	PAGE-UP	0A2X
	PAGE-DOWN	0A3X
	, 	131, 128
	, 	132, 129
	, 	133, 130
		150

The module EditKeys allows you to determine the keyboard code of any key pressed. For cross-platform portability, Oberon does not normally support all keys available on your keyboard. *)
BIER
  
   0
  r
  
    <       g 
     C  Syntax10.Scn.Fnt 13.10.2002  14:51:47  "         d      d
     C  &         X       X     C  TimeStamps.New TextGadgets.NewStyleProc  