TextDocs.NewDoc     U   CWindowsLeft ;   WindowsRight D  WindowsTop "   WindowsButtom g  Color    Flat  Locked  Controls  Org    BIER           3    Syntax10.Scn.Fnt  .   Oberon10.Scn.Fnt      I         Z   Syntax10i.Scn.Fnt  [   Syntax12.Scn.Fnt          B            .        /            
    .        /        )        6        %    
    8        D                     ?                                        /    *        }    ,    ;    @    "        f        ,            
        2        I                    )    3            &    R            r    k        C               3                    '    D    G    I    /           O   =    Q   8    E   ,        1    
   1       5    
   S       )               *                    T   <       =    0   (    e    ,    K   !       ~G  (* Copyright (c) 1994 - 2000 Emil J. Zeller *)

MODULE Displays; (** non-portable / source: Win32.Displays.Mod *)	(* ejz   *)
	IMPORT SYSTEM, Kernel32, Kernel, FileDir, Modules, Objects, Threads, User32, GDI32;

(** Module Displays is the base modle for implementing Display, Viewers, Input and Oberon.
This makes it possible to use multiple logical displays. Where a display is either an (Windows) application window, (Windows) control window or a offscreen bitmap.
*)

	CONST
		MaxFonts = 255; (* must be < 256 *) LineCacheSize = 16;
	(** Event ids: *)
		create* = 0; remove* = 1;	(** display has been created or destroyed *)
		restore* = 2; suspend* = 3;	(** display has been minimized or restored *)
		redraw* = 4; resize* = 5;	(** display needs redraw *)
		print* = 6;	(** print the display in the give context *)
		focus* = 7; defocus* = 8;	(** display got or lost the keyboard focus *)
		consume* = 9; track* = 10;	(** keyboard or mouse data available *)
		update* = 11;	(** notification, that an object has been updated *)
		execute* = 12;	(** request to execute a command *)
		quit* = 13;	(** notification, that the Event service is shutdown *)
		ping* = 14;	(** checks whether the event dispatcher (Oberon.Loop) is running *)
		wheel* = 15;	(** mouse wheel *)
	
	TYPE
		(** character metric data *) 
		MetricData* = RECORD
			dx*, x*, y*, w*, h*: LONGINT
		END;

		(** font information *)
		Font* = POINTER TO RECORD
			hFont*: GDI32.HFont;
			metrics*: ARRAY 256 OF MetricData;
			number*: LONGINT;
			height*, minX*, maxX*, minY*, maxY*: LONGINT;
			family*: ARRAY GDI32.LFFaceSize OF CHAR;
			size*: LONGINT; style*: SET
		END;

		(** a pseudo font pattern *)
		FontPattern* = LONGINT; (** character (bits 0.. 7), font number (bits 8.. 15), unused (= 0) (bits (16 .. 31) *)

		(** a Bitmap Pattern used by Raster fonts and Display.Pattern *)
		Pattern* = POINTER TO PatternDesc;
		PatternDesc* = RECORD
			x*, y*: LONGINT; (* offset in bitmap *)
			w*, h*: LONGINT;
			hBm*: GDI32.HBitmap;
			next*: Pattern (* for GC *)
		END;

		(** an Oberon raster font *)
		RasterFont* = POINTER TO RECORD (Font)
			fonRes*: FileDir.FileName; (* name of the FON file *)
			patterns*: ARRAY 256 OF PatternDesc
		END;

		(** Event object *)
		Event* = POINTER TO RECORD
			disp*: Display;	(** target display, NIL for broadcast *)
			id*,	(** create, remove, restore, suspend, redraw, resize, print, focus, defocus, consume, track, update, execute, quit, ping *)
			state: LONGINT;
			done-: Threads.Event;	(** # NIL, call Threads.Set(event.done) when event done *)
			next: Event
		END;

		InputEvent* = POINTER TO RECORD (Event)	(** id: consume, track, wheel *)
			keys*: SET;	(** mouse buttons, numbered from the right to the left as 0, 1, 2
									3: x-button, 31: wheel *)
			X*, Y*: LONGINT;	(** mouse position (relative to display) *)
			zDelta*: LONGINT;	(** wheel roation *)
			ch*: CHAR	(** character typed *)
		END;

		UpdateEvent* = POINTER TO RECORD (Event)	(** id: update *)
			obj*: Objects.Object
		END;

		PrintEvent* = POINTER TO RECORD (Event)	(** id: print *)
			X*, Y*, W*, H*: LONGINT;	(** the region to print to *)
			hDC*: User32.HDC	(** Kernel32.NULL: print as document *)
		END;

		CommandEvent* = POINTER TO RECORD (Event)	(** id: execute *)
			cmd*: FileDir.FileName;	(** command string to be executed *)
			executor*: Objects.Object
		END;

		DisplayProc* = PROCEDURE (disp: Display);

		(** Display object *)
		Display* = POINTER TO RECORD (Objects.Object)
			hWnd*: User32.HWND;	(** handle of this window *)
			hWndParent*: User32.HWND;	(** handle of the parent window, = hWnd for document windows *)

			(** the displays device context, if updateDC = TRUE you need to
				call getDC first to get a valid context *)
			getDC*, releaseDC*: DisplayProc;
			hDC*: User32.HDC; updateDC*: BOOLEAN;

			width*, height*: LONGINT;	(** current size *)

			hRgn: User32.HRgn;
			clipL*, clipR*, clipT*, clipB*: LONGINT;	(** clipping rectangle *)

			(* character cache *)
			cacheChars: ARRAY LineCacheSize OF CHAR; cacheLen: LONGINT;
			cacheFont: Font; cacheCol: GDI32.ColorRef; cacheMode: LONGINT;
			cacheX0, cacheY0, cacheX: LONGINT;
			
			(* cached resources *)
			bkColor, textColor: GDI32.ColorRef;
			hBrush: GDI32.HBrush; brushCol: GDI32.ColorRef; brushBm: GDI32.HBitmap;
			hPen: GDI32.HPen; penCol: GDI32.ColorRef; penWidth: LONGINT;
			rop2: LONGINT;

			link-: Display (** list of all displays *)
		END;

	VAR
		fontTable-: ARRAY MaxFonts OF Font; (** font table *)
		root-: Display; (** list of all displays *)
		desktop-: Display; (** display wrapper for the desktop *)
		events, lastEvent: Event;
		moduleCS: Kernel32.CriticalSection;
		(** this event is set when new event objects (nEvents) are available *)
		eventObj-: POINTER TO RECORD (Threads.Event) nEvents-: LONGINT END;

	(** read the next event from the event queue *)
	PROCEDURE GetEvent*(): Event;
		VAR event: Event;
	BEGIN
		Kernel32.EnterCriticalSection(moduleCS);
		IF events # lastEvent THEN
			event := events.next; events.next := event.next;
			event.state := 0; DEC(eventObj.nEvents);
			IF eventObj.nEvents = 0 THEN lastEvent := events END
		ELSE
			event := NIL
		END;
		Kernel32.LeaveCriticalSection(moduleCS);
		RETURN event
	END GetEvent;

	(** put a new event into the event queue, returns TRUE if the event was dispatched within
		timeOut milliseconds, use Threads.Infinite for blocking wait *)
	PROCEDURE PutEvent*(event: Event; disp: Display; id: LONGINT; timeOut: LONGINT): BOOLEAN;
	BEGIN
		IF Threads.oberonLoop = NIL THEN
			RETURN FALSE
		ELSIF event = NIL THEN
			IF timeOut = 0 THEN
				Kernel32.EnterCriticalSection(moduleCS);
				event := events.next;
				WHILE event # events DO
					IF (event.disp = disp) & (event.id = id) THEN
						Kernel32.LeaveCriticalSection(moduleCS);
						RETURN TRUE
					END;
					event := event.next
				END;
				Kernel32.LeaveCriticalSection(moduleCS)
			END;
			NEW(event)
		ELSIF event.state = 1 THEN
			RETURN FALSE
		END;
		IF (timeOut > 0) OR (timeOut = Threads.Infinite) THEN
			NEW(event.done); Threads.Create(event.done)
		ELSE
			event.done := NIL
		END;
		event.disp := disp; event.id := id;
		Kernel32.EnterCriticalSection(moduleCS);
		lastEvent.next := event; event.next := events; lastEvent := event;
		event.state := 1; INC(eventObj.nEvents);
		Kernel32.SetEvent(eventObj.handle);
		Kernel32.LeaveCriticalSection(moduleCS);
		IF event.done # NIL THEN
			RETURN Threads.Wait(event.done, timeOut)
		ELSE
			RETURN TRUE
		END
	END PutEvent;

	(** count the number of Keyboard events in the event queue *)
	PROCEDURE AvailChar*(): LONGINT;
		VAR event: Event; avail: LONGINT;
	BEGIN
		avail := 0;
		Kernel32.EnterCriticalSection(moduleCS);
		event := events.next;
		WHILE event # events DO
			IF event.id = consume THEN INC(avail) END;
			event := event.next
		END;
		Kernel32.LeaveCriticalSection(moduleCS);
		RETURN avail
	END AvailChar;

	(** read the next Keyboard event from the event queue *)
	PROCEDURE ReadChar*(VAR ch: CHAR);
		VAR pevent, event: Event;
	BEGIN
		LOOP
			Kernel32.EnterCriticalSection(moduleCS);
			pevent := events; event := events.next;
			WHILE event # events DO
				IF event.id = consume THEN
					pevent.next := event.next;
					event.state := 0; DEC(eventObj.nEvents);
					IF event = lastEvent THEN lastEvent := pevent END;
					ch := event(InputEvent).ch;
					Kernel32.LeaveCriticalSection(moduleCS);
					RETURN				
				END;
				pevent := event; event := event.next
			END;
			Kernel32.LeaveCriticalSection(moduleCS)
		END
	END ReadChar;

	(** put a Keyboard event into the event queue *)
	PROCEDURE WriteChar*(disp: Display; ch: CHAR);
		VAR event: InputEvent; done: BOOLEAN;
	BEGIN
		NEW(event); event.ch := ch;
		done := PutEvent(event, disp, consume, 0)
	END WriteChar;

	(** put a Command event into the event queue *)
	PROCEDURE PutCmd*(disp: Display; executor: Objects.Object; cmd: ARRAY OF CHAR; timeOut: LONGINT): BOOLEAN;
		VAR event: CommandEvent;
	BEGIN
		NEW(event); COPY(cmd, event.cmd); event.executor := executor;
		RETURN PutEvent(event, disp, execute, timeOut)
	END PutCmd;

	(** put an Update event into the event queue *)
	PROCEDURE UpdateObj*(disp: Display; obj: Objects.Object);
		VAR event: UpdateEvent; e: Event; done: BOOLEAN;
	BEGIN
		Kernel32.EnterCriticalSection(moduleCS);
		e := events.next;
		WHILE e # events DO
			IF (e.disp = disp) & (e IS UpdateEvent) THEN
				IF e(UpdateEvent).obj = obj THEN
					Kernel32.LeaveCriticalSection(moduleCS);
					RETURN
				END
			END;
			e := e.next
		END;
		NEW(event); event.obj := obj; done := PutEvent(event, disp, update, 0);
		Kernel32.LeaveCriticalSection(moduleCS)
	END UpdateObj;

(** change the state of a displays device context *)

	PROCEDURE SetBkColor*(disp: Display; col: GDI32.ColorRef);
	BEGIN
		IF disp.bkColor # col THEN
			GDI32.SetBkColor(disp.hDC, col); disp.bkColor := col
		END
	END SetBkColor;

	PROCEDURE SetTextColor*(disp: Display; col: GDI32.ColorRef);
	BEGIN
		IF disp.textColor # col THEN
			GDI32.SetTextColor(disp.hDC, col); disp.textColor := col
		END
	END SetTextColor;

	PROCEDURE SetNullBrush*(disp: Display);
		VAR hBr, hOldBr: GDI32.HBrush;
	BEGIN
		hBr := GDI32.GetStockObject(GDI32.NullBrush);
		hOldBr := GDI32.SelectObject(disp.hDC, hBr);
		GDI32.DeleteObject(hOldBr);
		disp.hBrush := hBr; disp.brushCol := -1; disp.brushBm := Kernel32.NULL
	END SetNullBrush;

	PROCEDURE SetPatternBrush*(disp: Display; hBm: GDI32.HBitmap);
		VAR hBr, hOldBr: GDI32.HBrush;
	BEGIN
		IF disp.brushBm # hBm THEN
			hBr := GDI32.CreatePatternBrush(hBm);
			hOldBr := GDI32.SelectObject(disp.hDC, hBr);
			GDI32.DeleteObject(hOldBr);
			disp.hBrush := hBr; disp.brushCol := -1; disp.brushBm := hBm
		END	
	END SetPatternBrush;

	PROCEDURE SetSolidBrush*(disp: Display; col: GDI32.ColorRef);
		VAR hBr, hOldBr: GDI32.HBrush;
	BEGIN
		IF disp.brushCol # col THEN
			hBr := GDI32.CreateSolidBrush(col);
			hOldBr := GDI32.SelectObject(disp.hDC, hBr);
			GDI32.DeleteObject(hOldBr);
			disp.hBrush := hBr; disp.brushCol := col; disp.brushBm := Kernel32.NULL
		END
	END SetSolidBrush;

	PROCEDURE SetNullPen*(disp: Display);
		VAR hPen, hOldPen: GDI32.HPen;
	BEGIN
		hPen := GDI32.GetStockObject(GDI32.NullPen);
		hOldPen := GDI32.SelectObject(disp.hDC, hPen);
		GDI32.DeleteObject(hOldPen);
		disp.hPen := hPen; disp.penCol := -1; disp.penWidth := 0
	END SetNullPen;

	PROCEDURE SetSolidPen*(disp: Display; width: LONGINT; col: GDI32.ColorRef);
		VAR hPen, hOldPen: GDI32.HPen;
	BEGIN
		IF (disp.penCol # col) OR (disp.penWidth # width) THEN
			hPen := GDI32.CreatePen(GDI32.PSSolid, width, col);
			hOldPen := GDI32.SelectObject(disp.hDC, hPen);
			GDI32.DeleteObject(hOldPen);
			disp.hPen := hPen; disp.penCol := col; disp.penWidth := width
		END
	END SetSolidPen;

	PROCEDURE SetROP2*(disp: Display; rop2: LONGINT);
	BEGIN
		IF disp.rop2 # rop2 THEN
			GDI32.SetROP2(disp.hDC, rop2); disp.rop2 := rop2		
		END
	END SetROP2;

	PROCEDURE EndClip*(disp: Display);
	BEGIN
		IF disp.hRgn # Kernel32.NULL THEN
			GDI32.SelectClipRgn(disp.hDC, Kernel32.NULL);
			GDI32.DeleteObject(disp.hRgn); disp.hRgn := Kernel32.NULL
		END
	END EndClip;

	PROCEDURE BeginClip*(disp: Display);
		VAR x, y, w, h: LONGINT;
	BEGIN
		EndClip(disp);
		x := disp.clipL; y := disp.clipB; w := disp.clipR-disp.clipL; h := disp.clipT-disp.clipB;
		IF (x > 0) OR (w < disp.width) OR (y > 0) OR (h < disp.height) THEN
			disp.hRgn := GDI32.CreateRectRgn(x, disp.height-y, x+w, disp.height-y-h);
			GDI32.SelectClipRgn(disp.hDC, disp.hRgn)
		END
	END BeginClip;

	(** add a font to the font table, a new font number is returned in font.number *)
	PROCEDURE RegisterFont*(font: Font);
		VAR i: LONGINT;
	BEGIN
		Kernel32.EnterCriticalSection(moduleCS);
		i := 0;
		WHILE fontTable[i] # NIL DO
			INC(i)
		END;
		fontTable[i] := font; font.number := i;
		Kernel32.LeaveCriticalSection(moduleCS)
	END RegisterFont;

	(** remove a font from the font table *)
	PROCEDURE UnregisterFont*(font: Font);
	BEGIN
		Kernel32.EnterCriticalSection(moduleCS);
		fontTable[font.number] := NIL; font.number := -1;
		Kernel32.LeaveCriticalSection(moduleCS)
	END UnregisterFont;

	(** flush the line cache *)
	PROCEDURE FlushCharacterCache*(disp: Display);
		VAR hOldFnt: GDI32.HFont;
	BEGIN
(* to do: cache current font and bkmode *)
		IF (disp # NIL) & (disp.cacheLen > 0) THEN
			IF disp.cacheMode = 2 THEN (* Display.invert *)
				SetROP2(disp, GDI32.R2NotXOrPen)
			ELSE
				SetROP2(disp, GDI32.R2CopyPen)
			END;
			hOldFnt := GDI32.SelectObject(disp.hDC, disp.cacheFont.hFont);
			SetTextColor(disp, disp.cacheCol);
			GDI32.SetBkMode(disp.hDC, GDI32.Transparent);
			GDI32.TextOut(disp.hDC, disp.cacheX0, disp.height-disp.cacheY0-disp.cacheFont.maxY(*-1*), disp.cacheChars, disp.cacheLen);
			hOldFnt := GDI32.SelectObject(disp.hDC, hOldFnt);
			disp.cacheLen := 0
		END;
		GDI32.GdiFlush()
	END FlushCharacterCache;

	(** add a character to the line cache *)
	PROCEDURE CacheCharacter*(disp: Display; col: GDI32.ColorRef; pat: FontPattern; X, Y, mode: LONGINT);
		VAR font: Font; dx, x, y, x0, y0, ch: LONGINT;
	BEGIN
		font := fontTable[pat DIV 256]; ch := pat MOD 256;
		dx := font.metrics[ch].dx;
		IF (ch # 9) & (dx > 0) THEN (* ? *)
			x := font.metrics[ch].x; y := font.metrics[ch].y;
			x0 := X - x; y0 := Y - y;
			IF disp.cacheLen = 0 THEN
				disp.cacheChars[0] := CHR(ch); disp.cacheLen := 1;
				disp.cacheFont := font; disp.cacheCol := col; disp.cacheMode := mode;
				disp.cacheX0 := x0; disp.cacheY0 := y0;
				disp.cacheX := x0 + dx
			ELSIF (disp.cacheFont # font) OR (disp.cacheLen >= LineCacheSize) OR (disp.cacheCol # col) OR
				(x0 # disp.cacheX) OR (y0 # disp.cacheY0) OR (mode # disp.cacheMode) THEN
				FlushCharacterCache(disp);
				disp.cacheChars[0] := CHR(ch); disp.cacheLen := 1;
				disp.cacheFont := font; disp.cacheCol := col; disp.cacheMode := mode;
				disp.cacheX0 := x0; disp.cacheY0 := y0;
				disp.cacheX := x0 + dx
			ELSE
				disp.cacheChars[disp.cacheLen] := CHR(ch); INC(disp.cacheLen);
				INC(disp.cacheX, dx)
			END
		END
	END CacheCharacter;

	(** add a new display to the list of installed displays *)
	PROCEDURE Add*(disp: Display; noView: BOOLEAN);
		VAR done: BOOLEAN;
	BEGIN
		Kernel32.EnterCriticalSection(moduleCS);
		disp.link := root; root := disp;
		IF ~noView THEN done := PutEvent(NIL, disp, create, 0) END;
		Kernel32.LeaveCriticalSection(moduleCS)
	END Add;

	(** remove a display from the list of installed displays *)
	PROCEDURE Remove*(disp: Display; noView: BOOLEAN);
		VAR w, pw: Display; pevent, event: Event; done: BOOLEAN;
	BEGIN
		Kernel32.EnterCriticalSection(moduleCS);
		pw := NIL; w := root;
		WHILE w # disp DO
			pw := w; w := w.link
		END;
		IF pw # NIL THEN
			pw.link := disp.link
		ELSIF root = disp THEN
			root := disp.link
		ELSE
			HALT(99)
		END;
		pevent := events; event := events.next;
		WHILE event # events DO
			IF event.disp = disp THEN
				pevent.next := event.next;
				event.state := 0; DEC(eventObj.nEvents);
				IF event = lastEvent THEN lastEvent := pevent END
			ELSE
				pevent := event				
			END;
			event := event.next
		END;
		Kernel32.LeaveCriticalSection(moduleCS);
		IF ~noView THEN
			done := PutEvent(NIL, disp, remove, 0);
			disp.releaseDC(disp); disp.cacheLen := 0
		END
	END Remove;

	(** default implementation of getDC *)
	PROCEDURE GetDC*(disp: Display);
	BEGIN
		disp.releaseDC(disp); disp.updateDC := FALSE
	END GetDC;

	(** default implementation of releaseDC *)
	PROCEDURE ReleaseDC*(disp: Display);
	BEGIN
		IF disp.hDC # Kernel32.NULL THEN
			EndClip(disp);
			disp.bkColor := -1; disp.textColor := -1;
			IF disp.hBrush # Kernel32.NULL THEN
				SetNullBrush(disp);
				GDI32.DeleteObject(disp.hBrush); disp.hBrush := Kernel32.NULL
			END;
			disp.brushCol := -1; disp.brushBm := Kernel32.NULL;
			IF disp.hPen # Kernel32.NULL THEN
				SetNullPen(disp);
				GDI32.DeleteObject(disp.hPen); disp.hPen := Kernel32.NULL
			END;
			disp.penCol := -1; disp.penWidth := -1;
			disp.rop2 := GDI32.R2CopyPen
		END;
		disp.updateDC := TRUE
	END ReleaseDC;

	(** initialize a new display *)
	PROCEDURE Init*(disp: Display);
	BEGIN
		disp.hWnd := Kernel32.NULL; disp.hWndParent := Kernel32.NULL;
		disp.getDC := GetDC; disp.releaseDC := ReleaseDC;
		disp.hDC := Kernel32.NULL; disp.updateDC := TRUE;
		
		disp.width := 0; disp.height := 0;

		disp.hRgn := Kernel32.NULL;
		disp.clipL := 0; disp.clipR := 0;
		disp.clipB := 0; disp.clipT := 0;

		disp.cacheLen := 0;

		disp.bkColor := -1; disp.textColor := -1;
		disp.hBrush := Kernel32.NULL; disp.brushCol := -1; disp.brushBm := Kernel32.NULL;
		disp.hPen := Kernel32.NULL; disp.penCol := -1; disp.penWidth := -1;
		disp.rop2 := GDI32.R2CopyPen
	END Init;

	PROCEDURE *GetDesktopDC(disp: Display);
	BEGIN
		GetDC(disp);
		disp.hDC := User32.GetDC(User32.HWNDDesktop);
		ASSERT(disp.hDC # Kernel32.NULL);
		BeginClip(disp); disp.updateDC := TRUE
	END GetDesktopDC;

	PROCEDURE *ReleaseDesktopDC(disp: Display);
	BEGIN
		ReleaseDC(disp);
		IF disp.hDC # Kernel32.NULL THEN
			User32.ReleaseDC(User32.HWNDDesktop, disp.hDC);
			disp.hDC := Kernel32.NULL
		END
	END ReleaseDesktopDC;

	PROCEDURE *TermMod();
		VAR done: BOOLEAN;
	BEGIN
		IF Threads.oberonLoop # NIL THEN
			IF Threads.oberonLoop # Threads.This() THEN
				done := PutEvent(NIL, NIL, quit, 10*1000)
			ELSE
				ASSERT(Kernel.isEXE)
			END
		END;
		Kernel32.EnterCriticalSection(moduleCS);
		eventObj.nEvents := 0; desktop.releaseDC(desktop);
		Kernel32.LeaveCriticalSection(moduleCS);
		Kernel32.DeleteCriticalSection(moduleCS)
	END TermMod;

	PROCEDURE InitMod();
		VAR i: LONGINT;
	BEGIN
		Kernel32.InitializeCriticalSection(moduleCS);
		Kernel32.EnterCriticalSection(moduleCS);
		i := 0;
		WHILE i < MaxFonts DO
			fontTable[i] := NIL; INC(i)
		END;
		root := NIL; NEW(desktop); Init(desktop);
		desktop.width := User32.GetSystemMetrics(User32.SMCXScreen);
		desktop.height := User32.GetSystemMetrics(User32.SMCYScreen);
		desktop.getDC := GetDesktopDC; desktop.releaseDC := ReleaseDesktopDC;

		NEW(events); events.done := NIL; events.next := events; lastEvent := events;
		events.id := -1; events.disp := NIL; events.state := 1;
		NEW(eventObj); Threads.Create(eventObj); eventObj.nEvents := 0;
		Modules.InstallTermHandler(TermMod);
		Kernel32.LeaveCriticalSection(moduleCS)
	END InitMod;

BEGIN
	InitMod()
END Displays.
BIERVL  gL   L    <       g 
     C  Syntax10.Scn.Fnt 28.01.2002  10:02:31  TimeStamps.New  