TextDocs.NewDoc     *Eg   CWindowsLeft    WindowsTop 6   Color    Flat  Locked  Controls  Org -   BIER           3  e   Oberon10.Scn.Fnt     Syntax10.Scn.Fnt                    3            G
  (* ETH Oberon, Copyright 2001 ETH Zuerich Institut fuer Computersysteme, ETH Zentrum, CH-8092 Zuerich.
Refer to the "General ETH Oberon System Source License" contract available at: http://www.oberon.ethz.ch/ *)

 (** Module Bitmaps provide a portable way to save and restore areas of the display. *)

MODULE Bitmaps; (** non-portable / source: Win32.Bitmaps.Mod *)	(* ejz  *)
	IMPORT SYSTEM, Kernel32, Kernel, User32, GDI32, Displays, Display;

	TYPE
		Bitmap* = POINTER TO RECORD (Displays.Display)
			hBm-, hOldBm: GDI32.HBitmap
		END;

	PROCEDURE *Finalize(bitmap: PTR);
	BEGIN
		WITH bitmap: Bitmap DO
			bitmap.releaseDC(bitmap);
			IF bitmap.hBm # Kernel32.NULL THEN
				GDI32.DeleteObject(bitmap.hBm); bitmap.hBm := Kernel32.NULL
			END
		END	
	END Finalize;

	PROCEDURE *GetDC(disp: Displays.Display);
		VAR hDC: User32.HDC;
	BEGIN
		WITH disp: Bitmap DO
			Displays.GetDC(disp);
			hDC := GDI32.CreateDC("DISPLAY", NIL, NIL, NIL);
			disp.hDC := GDI32.CreateCompatibleDC(hDC);
			GDI32.DeleteDC(hDC);
			disp.hOldBm := GDI32.SelectObject(disp.hDC, disp.hBm);
			Displays.BeginClip(disp)
		END
	END GetDC;

	PROCEDURE *ReleaseDC(disp: Displays.Display);
	BEGIN
		WITH disp: Bitmap DO
			IF disp.hDC # Kernel32.NULL THEN
				disp.hOldBm := GDI32.SelectObject(disp.hDC, disp.hOldBm); disp.hOldBm := Kernel32.NULL;
				Displays.ReleaseDC(disp);
				GDI32.DeleteDC(disp.hDC); disp.hDC := Kernel32.NULL
			END
		END
	END ReleaseDC;

	(** Allocate a bitmap of width w and height h. NIL is returned when not enough memory is available. *)
	PROCEDURE New*(w, h: LONGINT): Bitmap;
		VAR bitmap: Bitmap; hDC: User32.HDC;
	BEGIN
		NEW(bitmap); Displays.Init(bitmap);
		bitmap.getDC := GetDC; bitmap.releaseDC := ReleaseDC;
		bitmap.hOldBm := Kernel32.NULL; bitmap.width := w; bitmap.height := h;
		hDC := GDI32.CreateDC("DISPLAY", NIL, NIL, NIL);
		bitmap.hBm := GDI32.CreateCompatibleBitmap(hDC, w, h);
		IF bitmap.hBm = Kernel32.NULL THEN
			Kernel.GC(); bitmap.hBm := GDI32.CreateCompatibleBitmap(hDC, w, h)
		END;
		GDI32.DeleteDC(hDC);
		IF bitmap.hBm # Kernel32.NULL THEN
			bitmap.clipL := 0; bitmap.clipB := 0;
			bitmap.clipR := MAX(INTEGER); bitmap.clipT := MAX(INTEGER);
			Kernel.RegisterObject(bitmap, Finalize, FALSE);
			RETURN bitmap
		END;
		RETURN NIL
	END New;

	PROCEDURE Open(disp: Displays.Display);
		VAR cur: Displays.Display;
	BEGIN
		Displays.FlushCharacterCache(disp);
		IF disp.updateDC THEN
			cur := Display.cur; Display.SetCurrent(NIL);
			disp.getDC(disp); Display.SetCurrent(cur)
		END
	END Open;

	PROCEDURE Close(disp: Displays.Display);
		VAR cur: Displays.Display;
	BEGIN
		IF disp IS Bitmap THEN
			cur := Display.cur; Display.SetCurrent(NIL);
			disp.releaseDC(disp); Display.SetCurrent(cur)
		END
	END Close;

	(** Copies a part (sx, sy, w, h) of a source bitmap (sB) to a destination bitmap (dB) at position (dx, dy, w, h). *)
	PROCEDURE CopyBlock*(src, dest: Displays.Display; sx, sy, w, h, dx, dy: LONGINT);
	BEGIN
		Open(src); Open(dest);
		IF (sx+w) > src.width THEN w := src.width-sx END;
		IF (sy+h) > src.height THEN h := src.height-sy END;
		GDI32.BitBlt(dest.hDC, dx, dest.height-dy, w, -h, src.hDC, sx, src.height-sy, GDI32.SrcCopy);
		Close(dest); Close(src)
	END CopyBlock;

END Bitmaps.

(** Remarks:

1. Coordinates are measured vertically from bottom (0) to top (bitmap height minus one), and from left (0) to right (bitmap width minus 1). *)
BIER  
   N  v      "         d      d
     C  <       g 
     C  Syntax10.Scn.Fnt 02.05.2004  15:58:48   "         d      d
     C  TextGadgets.NewStyleProc TimeStamps.New  