(**************************************************************************

Name:           Timer
Purpose:        System based timing functions
Version:	1.1
Predecessor:    1.0
Changes:        Procedure Test extended, b ambigous.
Target platform:PC>=386
Compiler:	Oberon 3
Date:           March 1995
Author:		Frank Hrebabetzky

***************************************************************************)

MODULE Timer;

IMPORT Oberon, Out;

CONST
  T0 = 300;	(* timer ticks per sec. *)
  
VAR
  a, b: REAL;


PROCEDURE Delay* (time:REAL);
VAR i: LONGINT;
BEGIN
  FOR i:=1 TO ENTIER (a*time-b) DO END;
END Delay;


PROCEDURE CalibrateDelay;
CONST TT = 500;	(* min. measurement interval in ticks *)
VAR i, n, n1, n2	: LONGINT;
    t		: REAL;
BEGIN
  Out.String("calibrating Time.Delay ... ");
  (* a *)
  a:= 1.0;   t:= 1.0E+5;
  REPEAT
    n1:= Oberon.Time();
    Delay(t);
    n2:= Oberon.Time();
    t:= 2 * t;
  UNTIL n2-n1>=TT;
  a:= T0*t*0.5 / (n2-n1);	(* b: some us << a*t (approx 1s), 0.5 experim. *)
  
  (* b *)
  n:= 100000;
  REPEAT
    n1:= Oberon.Time();
    FOR i:=1 TO n DO Delay (0.0) END;
    n2:= Oberon.Time();
    n:= 2 * n;
  UNTIL n2-n1>=TT;
  b:= (n2-n1) / (T0*n) + 0.5;
  Out.Ln;   Out.String("a = ");   Out.Real(a,10);
  Out.Ln;   Out.String("b = ");   Out.Real(b,10);   Out.Ln;
  Out.String("done");   Out.Ln;
END CalibrateDelay;


PROCEDURE Test*;
CONST N = 1000000;
VAR i, n1, n2, t0, t1: LONGINT;
BEGIN
  Out.String("Delay(0.1) ... ");
  n1:= Oberon.Time();
  Delay(0.1);
  n2:= Oberon.Time();
  Out.Int (n2-n1, 5);   Out.String(" ticks");   Out.Ln;

  Out.String("Delay(1.0) ... ");
  n1:= Oberon.Time();
  Delay(1.0);
  n2:= Oberon.Time();
  Out.Int (n2-n1, 5);   Out.String(" ticks");   Out.Ln;

  Out.String("Delay(10.0) ... ");
  n1:= Oberon.Time();
  Delay(10.0);
  n2:= Oberon.Time();
  Out.Int (n2-n1, 5);   Out.String(" ticks");   Out.Ln;

  Out.String("Delay(0.0) ... ");
  n1:= Oberon.Time();
  FOR i:=1 TO N DO END;
  n2:= Oberon.Time();
  t0:= n2-n1;
  n1:= Oberon.Time();
  FOR i:=1 TO N DO Delay(0.0) END;
  n2:= Oberon.Time();
  t1:= n2-n1;
  Out.Int(N,8);   Out.String(" iter.,  ");
  Out.Int(t1,4);   Out.String(" ticks, ");
  Out.Real (1.0E+6 * (t1-t0) / (N*T0), 10);   Out.String("us");   Out.Ln;
END Test;


BEGIN
  CalibrateDelay;
END Timer.

Timer.Test