(**************************************************************************

Name:          Math0.Mod 
Purpose:        simple mathematical utilities
Version:	1.0
Predecessor:    0.2
Changes:        Min, Max added
Target platform:PC>=386
Compiler:	Oberon 3
Date:           December 1995
Author:		Frank Hrebabetzky

***************************************************************************)

MODULE Math0;

IMPORT Math;

VAR
  eps*, min*, pi2*	: REAL;
  ln10, x, y	: REAL;
  
  
PROCEDURE mini* (a,b:INTEGER):INTEGER;
BEGIN IF a<b THEN RETURN a ELSE RETURN b END
END mini;


PROCEDURE maxi* (a,b:INTEGER):INTEGER;
BEGIN IF a>b THEN RETURN a ELSE RETURN b END
END maxi;


PROCEDURE minr* (a,b:REAL):REAL;
BEGIN IF a<b THEN RETURN a ELSE RETURN b END
END minr;


PROCEDURE maxr* (a,b:REAL):REAL;
BEGIN IF a>b THEN RETURN a ELSE RETURN b END
END maxr;


PROCEDURE Min* (VAR x:ARRAY OF REAL; ia,ib:INTEGER): INTEGER;
(* Index of minimum of x in index interval [ia,ib]. *)
VAR i,j: INTEGER;
    m: REAL;
BEGIN
  j:= ia;   m:= x[j];
  FOR i:=ia+1 TO ib DO
    IF x[i]<m THEN m:= x[i];   j:= i   END;
  END;
  RETURN j;
END Min;


PROCEDURE Max* (VAR x:ARRAY OF REAL; ia,ib:INTEGER): INTEGER;
(* Index of maximum of x in index interval [ia,ib]. *)
VAR i,j: INTEGER;
    m: REAL;
BEGIN
  j:= ia;   m:= x[j];
  FOR i:=ia+1 TO ib DO
    IF x[i]>m THEN m:= x[i];   j:= i   END;
  END;
  RETURN j;
END Max;


PROCEDURE Polar* (x,y:REAL; VAR r,phi:REAL);
BEGIN
  r:= Math.sqrt(x*x + y*y);
  IF ABS(x)<eps THEN IF y>0 THEN phi:=Math.pi/2 ELSE phi:=-Math.pi/2 END
  ELSIF x>0 THEN phi:= Math.arctan(y/x)
  ELSE phi:= Math.arctan(y/x) + Math.pi
  END
END Polar;


PROCEDURE Cart* (r,phi:REAL; VAR x,y:REAL);
BEGIN
  x:= r * Math.cos(phi);
  y:= r * Math.sin(phi);
END Cart;


PROCEDURE lg* (x:REAL):REAL;
BEGIN RETURN Math.ln(x) / ln10
END lg;


PROCEDURE exp10* (x:REAL):REAL;
BEGIN RETURN Math.exp(x*ln10)
END exp10;



BEGIN
  min:= 4 / MAX(REAL);	(* 4 is a guess only. 1 perhaps yields 0. *)
  pi2:= 2 * Math.pi;
  ln10:= Math.ln(10.0);
  eps:=1.0;
  x:= 2.0;
  y:= 1.0;
  WHILE y<x DO
    eps:= eps * 0.5;   x:= 1.0 + eps;
  END;
  eps:= eps * 2.0;
END Math0.