TextDocs.NewDoc     hZ   CWindowsLeft $   WindowsRight   WindowsTop 9   WindowsButtom |  Color    Flat  Locked  Controls  Org    BIER           3     Oberon10.Scn.Fnt     Syntax10.Scn.Fnt  S            
    ]   
            O          Syntax10b.Scn.Fnt      
     (* ETH Oberon, Copyright 2001 ETH Zuerich Institut fuer Computersysteme, ETH Zentrum, CH-8092 Zuerich.
Refer to the "General ETH Oberon System Source License" contract available at: http://www.oberon.ethz.ch/ *)

MODULE Configuration; (** non-portable / source: Win32.Configuration.Mod *)	(* ejz   *)
	IMPORT Registry, FileDir, Modules, Display, Texts, Viewers, Input, Oberon;

	CONST
		CR = 0DX; ESC = 1BX;
		Default = "Configuration.Text";

	VAR
		W: Texts.Writer;
		sX, sY: INTEGER;	(* saved coordinates for newm viewer [used in Marker ] *)

	(** Execute commands contained in the text. Each command must be on a separate line. *)
	PROCEDURE do*(T: Texts.Text; beg, end: LONGINT);
		VAR S: Texts.Scanner; pos: LONGINT; res: INTEGER;
		PROCEDURE NextCmd();
			VAR tR: Texts.Reader; ch: CHAR;
		BEGIN
			IF pos < end THEN 
				Texts.OpenReader(tR, T, pos); Texts.Read(tR, ch);
				LOOP
					WHILE ~tR.eot & (ch # CR) DO Texts.Read(tR, ch) END;
					Texts.Read(tR, ch);
					IF tR.eot THEN
						EXIT
					ELSIF (ch > " ") & (ch # "!") & (ch # "#") THEN
						pos := Texts.Pos(tR)-1;
						Texts.OpenScanner(S, T, pos); Texts.Scan(S);
						RETURN
					END
				END
			END;
			S.class := Texts.Inval
		END NextCmd;
		PROCEDURE FirstCmd();
			VAR tR: Texts.Reader; ch: CHAR;
		BEGIN
			IF pos < end THEN 
				Texts.OpenReader(tR, T, pos); Texts.Read(tR, ch);
				IF ~tR.eot & (ch > " ") & (ch # "!") & (ch # "#") THEN
					pos := Texts.Pos(tR)-1;
					Texts.OpenScanner(S, T, pos); Texts.Scan(S);
					RETURN
				END
			END;
			NextCmd()
		END FirstCmd;
		PROCEDURE UserInterrupt(): BOOLEAN;
			VAR ch: CHAR;
		BEGIN
			WHILE Input.Available() # 0 DO
				Input.Read(ch);
				IF ch = ESC THEN RETURN TRUE END;
				Input.Write(ch)
			END;
			RETURN FALSE
		END UserInterrupt;
	BEGIN
		pos := beg; FirstCmd();
		WHILE (S.class = Texts.Name) & (pos < end) & ~UserInterrupt() DO
			pos := Texts.Pos(S) - 1; 
			Oberon.Par.vwr := Oberon.MarkedViewer();
			Oberon.Par.frame := Oberon.MarkedFrame();
			Oberon.Par.text := T; Oberon.Par.pos := pos;
			Oberon.Call(S.s, Oberon.Par, FALSE, res);
			IF res # 0 THEN
				Texts.WriteString(W, "Call error: "); Texts.WriteString(W, Modules.resMsg);
				Texts.WriteLn(W); Texts.Append(Oberon.Log, W.buf)
			END;
			NextCmd()
		END
	END do;

	PROCEDURE ValidX(X: INTEGER): BOOLEAN;
	BEGIN
		RETURN (X >= 0) & (X < Display.Width)
	END ValidX;

	PROCEDURE ValidY(Y: INTEGER): BOOLEAN;
	BEGIN
		RETURN (Y >= 0) & (Y < Display.Height)
	END ValidY;

	(** Set the star marker under program control:
		Configuration.Marker set save		(* set at saved position *)
		Configuration.Marker set this		(* set to current viewer *)
		Configuration.Marker set system		(* in system track *)
		Configuration.Marker set user		(* in user track *)
		Configuration.Marker set X Y		(* at absolute pixel position X, Y *)
		Configuration.Marker set X% Y%		(* at relative pixel position X, Y *)
		Configuration.Marker save system		(* save marker in system track *)
		Configuration.Marker save user		(* save marker in user track *)
	*)
	PROCEDURE Marker*;
		VAR S: Texts.Scanner; V : Viewers.Viewer; cM: Oberon.ControlMsg;
	BEGIN
		Texts.OpenScanner(S, Oberon.Par.text, Oberon.Par.pos); Texts.Scan(S);
		IF S.class # Texts.Name THEN RETURN END;
		IF S.s = "set" THEN
			Texts.Scan(S); cM.id := Oberon.mark + 999;
			IF (S.class = Texts.Name) & (S.s = "saved") THEN
				V := Viewers.This(sX + 1, sY - 1);
				IF (V # NIL) & (V.X = sX) & (V.Y + V.H = sY) THEN
					cM.id := Oberon.mark; cM.X := V.X + V.W DIV 2; cM.Y := V.Y + V.H DIV 2
				END
			ELSIF (S.class = Texts.Name) & (S.s = "this") THEN
				IF Oberon.Par.vwr # NIL THEN
					cM.id := Oberon.mark; cM.X := Oberon.Par.vwr.X + Oberon.Par.vwr.W DIV 2; 
					cM.Y := Oberon.Par.vwr.Y + Oberon.Par.vwr.H DIV 2
				END
			ELSIF (S.class = Texts.Name) & (S.s = "system") THEN
				Oberon.AllocateSystemViewer(Oberon.SystemTrack(0), cM.X, cM.Y);
				cM.id := Oberon.mark
			ELSIF (S.class = Texts.Name) & (S.s = "user") THEN
				Oberon.AllocateUserViewer(Oberon.UserTrack(0), cM.X, cM.Y);
				cM.id := Oberon.mark
			ELSIF (S.class = Texts.Int) & (S.i >= 0) THEN
				cM.X := SHORT(S.i); Texts.Scan(S);
				IF (S.class = Texts.Int) & (S.i >= 0) THEN
					cM.Y := SHORT(S.i);
					IF ValidX(cM.X) & ValidY(cM.Y) THEN cM.id := Oberon.mark END
				ELSIF (S.class = Texts.Char) & (S.c = "%") THEN
					Texts.Scan(S);
					IF (S.class = Texts.Int) & (S.i >= 0) THEN
						cM.Y := SHORT(S.i*Display.Height DIV 100);
						cM.X := SHORT(LONG(Display.Width)*cM.X DIV 100);
						IF ValidX(cM.X) & ValidY(cM.Y) THEN cM.id := Oberon.mark END
					END
				END
			END;
			IF cM.id = Oberon.mark THEN	(* set marker *)
				IF cM.Y >= Display.Height THEN cM.Y := Display.Height-1 END;
				V := Viewers.This(cM.X, cM.Y); IF V # NIL THEN Viewers.Send(V, cM) END
			END
		ELSIF S.s = "save" THEN
			Texts.Scan(S);
			IF S.class = Texts.Name THEN
				IF S.s = "system" THEN
					Oberon.AllocateSystemViewer(Oberon.SystemTrack(0), sX, sY)
				ELSIF S.s = "user" THEN
					Oberon.AllocateUserViewer(Oberon.UserTrack(0), sX, sY)
				ELSE sX := -1; sY := -1
				END
			END
		END
	END Marker;

	(** Execute "Configuration.Text" (called by System.StartEXE/System.StartDLL).
		The name of the configuration file is stored in the registry under the key <name>.
		The default value is Configuration.Text. *)
	PROCEDURE Load*(name: ARRAY OF CHAR): BOOLEAN;
		VAR config: FileDir.FileName; T: Texts.Text;
	BEGIN
		IF name # "" THEN
			Registry.GetKeyValue(Registry.CurrentUser, Registry.oberonSystem, name, config);
			IF Registry.res # Registry.Done THEN COPY(Default, config) END
		ELSE
			COPY(Default, config)
		END;
		NEW(T); Texts.Open(T, config);
		IF T.len > 0 THEN
			do(T, 0, T.len); RETURN TRUE
		END;
		RETURN FALSE
	END Load;

BEGIN
	Texts.OpenWriter(W)
END Configuration.
BIERP  a       <       g 
     C  Syntax10.Scn.Fnt 13.10.2002  10:23:51  TimeStamps.New  