/*
	List element manipulation and creation. Descriptor logic.
*/

#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <float.h>
#include "format.fdf"
#include "service.fdf"
#include "manager.fdf"
#include "manager.h"
#include "concon.h"
#include "global.h"
#include "symbol.h"

int numDescrs = 0;

List *cc_newDescr( Descr **descrPP, List *lP )
	{
	List *newP = NULL;
	List new;

	numDescrs++;
	
	cc_clearLElm( &new );
	new.nextP = lP;
    new.u.p.type = DESCRIPTOR;
	new.data.dataP = NULL;

    newP = proMem_getAvailAndCopy( &new );
	*descrPP = newP;
	return *descrPP;
	} 	

void cc_freeDescr( Descr **descrPP )
	{
    if (descrPP == NULL)
		return;
	if (*descrPP == NULL)
		return;
    numDescrs--;
    cc_disposeLElm( *descrPP );
	*descrPP = NULL;
	}

void cc_insert( Descr *descrP, List *toInsertP )
	{
	List *nextP = descrP->nextP;
	List *traverserP = (List *)descrP;

	descrP->nextP = toInsertP;
	while (traverserP->nextP != NULL)
		traverserP = traverserP->nextP;
	traverserP->nextP = nextP;	
	}

Descr *cc_copy( List *lP, Inherit full )
	{
	Descr *descrP;
	
	cc_newDescr( &descrP, NULL );
	proMem_copyList( descrP, lP, full );
	return descrP;
	}

void cc_copyAndInsert( Descr *descrP, List *toInsertP, Inherit full )
	{
	Descr *newDescrP = cc_copy( toInsertP, full );
	
	cc_insert( descrP, newDescrP->nextP );
	cc_freeDescr( &newDescrP );
	}

void cc_clearDescr( Descr *descrP )
	{
	descrP->nextP = NULL;
	}

void cc_clearLElm( List *lP )
	{
    lP->u.b = 0;
	lP->nextP    = lP->data.dataP    = NULL;
	}	

List *cc_disposeLElm( List *toDeleteP )
	{
	List *nextP = toDeleteP->nextP;
    toDeleteP->u.b = 0;
	toDeleteP->nextP = availableP;
	availableP = toDeleteP;
	listFree++;
	return nextP;
	}



void cc_makeInteger( List *lP, long integer )
	{
    lP->u.p.type = INTEGER;
	lP->data.integer = integer;
	}

void cc_makeReal( List *lP, Real real )
	{
    lP->u.p.type = REAL;
	lP->data.real = real;
	}

void cc_makeSubList( List *lP, List *subP )
	{
    lP->u.p.type = SUBLIST;
	lP->data.dataP = subP;
	}

void cc_makeAtom( List *lP, char *s )
	{
    lP->u.p.type = ALPHA;
	if ((lP->data.dataP = proMem_lookup( s )) == NULL)
		{
		if (LEX_MEM_LEFT <= strlen( s ))
			return;
		strcpy(lexTailP, s );
		stateP->token = ALPHA;
		if (s[0] == '\"')
            lP->u.p.type = stateP->token = LITERAL;
		lP->data.dataP = proMem_insert();
		}
	else
        lP->u.p.type = ((List *)lP->data.dataP)->u.p.
									type;
	}
	
void cc_bind( List **headPP, List *newTailP )
	{
	if (*headPP != NULL)
		{
		(*headPP)->nextP = newTailP;
		while ((*headPP)->nextP != NULL)
			(*headPP) = (*headPP)->nextP;
		}
	}
	
void cc_unbind( List *headP )
	{
	if (headP != NULL)
		headP->nextP = NULL;
	}

List *cc_binding( List *lP )
	{
	if (lP == NULL)
		return NULL;
	else
		return lP->nextP;
	}
	
List *cc_getSub( List *lP )	
	{
	int  type ;
	
	if (lP == NULL)
		return NULL;
    type = lP->u.p.type;
	if (type == SUBLIST ||
		type == SYMBOL  ||
		type == KEYWORD ||
		type == ALPHA)
		return lP->data.dataP;
	else
		return NULL;
	}

void cc_intToReal( List *lP )
	{
	if (lP == NULL)
		return;
    if (lP->u.p.type == INTEGER)
		{
		lP->data.real = (Real)lP->data.integer;
        lP->u.p.type = REAL;
		}
	}

Inherit cc_equalLElms( List *firstP, List *secondP )
	{
	if (firstP == NULL || secondP == NULL)
		return FALSE;
    if (firstP->u.p.type != secondP->u.p.type)
		return FALSE;
    switch (firstP->u.p.type)
		{
		case INTEGER:
			if (firstP->data.integer !=
				secondP->data.integer)
				return FALSE;
			break;
		case REAL:
			if ( fabs(
				fabs(firstP->data.real) -
				fabs(secondP->data.real))
                > 2 * FLT_EPSILON)
				return FALSE;
			break;
		case ALPHA:
		case LITERAL:
		case KEYWORD:
		case ACTIONFUNC:
			if (firstP->data.dataP != 
				secondP->data.dataP)
				return FALSE;
			break;
		case SUBLIST:
			{
			List *fstSubP = firstP->data.dataP,
			     *sndSubP = secondP->data.dataP;			

			while (fstSubP != NULL)
				{
				if (!cc_equalLElms( fstSubP, sndSubP ))
					return FALSE;
				fstSubP = fstSubP->nextP;
				sndSubP = sndSubP->nextP;
				}
			}
			break;
		default:
			return FALSE;
		}
	return TRUE;
	}

Descr *cc_assoc( List *handleP, List *aListP )
	{
	Descr *descrP;
	List *singleP;
	List new;
	
	cc_newDescr( &descrP, NULL );
	
	if (handleP == NULL || aListP == NULL)
		return descrP;
    if (aListP->u.p.type != SUBLIST)
		return descrP;
	aListP = aListP->data.dataP;
	while (aListP != NULL)
		{
        if (aListP->u.p.type == SUBLIST)
			{
			singleP = aListP->data.dataP;
            if (handleP->u.p.type == singleP->u.p.type &&
				!memcmp( &handleP->data, &singleP->data, 
						 sizeof(Data)))
				{
				cc_clearLElm( &new );
				cc_makeSubList( &new, singleP );
				cc_copyAndInsert( descrP, &new, FALSE );
				return descrP;
				}
			}
		aListP = aListP->nextP;
		}
	return descrP;
	}

List **cc_variable( State *stP, List *lP )
	{
	List **returnPP = NULL;
	Descr *localDescrP;
	
	if (lP == NULL)
		return returnPP;
    if (lP->u.p.type == KEYWORD)
		return (List **)(&((List *)lP->data.dataP)->
					nextP);
		
    if (lP->u.p.type != ALPHA)
		return returnPP;
	localDescrP = cc_assoc( lP, stP->localP );
	if (localDescrP->nextP == NULL)
		returnPP = (List **)(&((List *)lP->data.dataP)->
					nextP);
	else
		returnPP = 
		(List **)(&((List *)
				((List *)localDescrP->nextP)->data.dataP)
					->nextP);
	cc_freeDescr( &localDescrP );
	return returnPP;
	}

Descr *cc_matchParams( List *parP, List *valP )
	{
	Descr *descrP;
	List *traverserP;
	List var, *holdP;

	cc_newDescr( &descrP, parP );
    if (parP->u.p.type != SUBLIST)
		{
		proFor_print("\nERROR - Bad arguments passed...");
		longjmp( env, 1 );
		}
	traverserP = parP->data.dataP;
	while (traverserP != NULL)
		{
		var   = *traverserP;
        var.u.p.locked = FALSE;
		var.nextP = valP;
		holdP = valP;
		if (valP == NULL)
			{
			if (traverserP->nextP != NULL)
				{
				proFor_print("\nERROR - Bad arguments passed...");
				longjmp( env, 1 );
				}
			}
		else
			valP  = valP->nextP;
        if (var.u.p.type != ALPHA)
			{
			proFor_print("\nERROR - Bad arguments passed...");
			longjmp( env, 1 );
			}
        cc_makeSubList( traverserP, proMem_getAvailAndCopy( &var ) );
		traverserP = traverserP->nextP;
		if (traverserP != NULL && holdP != NULL)
			holdP->nextP = NULL;
		}
	return descrP;
	}

void cc_set( Inherit quotedBind, List *setListP, State *stP )
    {
    Descr *tailDescrP;
    List *tmpP;

    cc_newDescr( &tailDescrP, cc_binding( setListP ) );
    tmpP = tailDescrP->nextP;
    cc_unbind( setListP );
    if (quotedBind)
        while (tmpP != NULL)
            {
            tmpP->u.p.quoted = TRUE;
            tmpP = tmpP->nextP;
            }
    if (setListP->u.p.type == ALPHA)
        if ( ((List *)setListP->data.dataP)->u.p.locked == FALSE)
            *cc_variable( stP, setListP ) = tailDescrP->nextP;
    cc_freeDescr( &tailDescrP );
    }


