/* gnuserv.h	-- peter
 *
 * $Header$
 * $Log$
 */

#ifndef _GNUSERV_H
#define _GNUSERV_H

#include <windows.h>
#include <stdio.h>

#undef  GNUSERV_DEBUG 

#define MAXPATHLEN  400
#define GSERV_BUFSZ 1000

#define EOT_STR     "\004"
#define EOT_CHR     '\004'

//
// The %s will be replaced by the host name or "." for localhost.
// The %08x will be replaced by the client-ID.
//
#define GNUSERV_SEND_MAILSLOT      "\\\\%s\\mailslot\\emacs\\gnuserv"
#define GNUSERV_RECEIVE_MAILSLOT   "\\\\.\\mailslot\\emacs\\gnuserv"
#define GNUSERV_SEND_CLIENTSLOT    "\\\\%s\\mailslot\\emacs\\gnuclient\\%08x"
#define GNUSERV_RECEIVE_CLIENTSLOT "\\\\.\\mailslot\\emacs\\gnuclient\\%08x"
#define GNUSERV_DEFAULT_HOST       "."

//
// Function prototypes
//
HANDLE CreateGnuServSlot (BOOL clientslot, DWORD clientid);
HANDLE ConnectToMailslot (char *host, BOOL clientslot, DWORD clientid);
void   DisconnectFromMailslot (HANDLE slot);
int    SendString (HANDLE slot, char *msg);
void   WaitForServerResult (HANDLE slot, BOOL echo);
BOOL   IsWindowsNT (void);
void   OutputErrorString (char *errormsg);

#endif
