/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.ooxml;

import net.sf.jasperreports.engine.JRAlignment;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.export.JRExporterGridCell;
import net.sf.jasperreports.engine.export.ooxml.DocxCellHelper;
import net.sf.jasperreports.engine.export.ooxml.XlsxParagraphHelper;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.util.JRColorUtil;

public class XlsxStyleInfo {
    protected int fontIndex;
    protected int borderIndex;
    protected String backcolor;
    protected String horizontalAlign;
    protected String verticalAlign;
    protected boolean isWrapText = true;

    public XlsxStyleInfo(int fontIndex, int borderIndex, JRExporterGridCell gridCell) {
        this(fontIndex, borderIndex, gridCell, true);
    }

    public XlsxStyleInfo(int fontIndex, int borderIndex, JRExporterGridCell gridCell, boolean isWrapText) {
        JRAlignment align;
        this.fontIndex = fontIndex;
        this.borderIndex = borderIndex;
        JRPrintElement element = gridCell.getElement();
        if (element != null && element.getModeValue() == ModeEnum.OPAQUE) {
            this.backcolor = JRColorUtil.getColorHexa(element.getBackcolor());
        } else if (gridCell.getBackcolor() != null) {
            this.backcolor = JRColorUtil.getColorHexa(gridCell.getBackcolor());
        }
        JRAlignment jRAlignment = align = element instanceof JRAlignment ? (JRAlignment)((Object)element) : null;
        if (align != null) {
            this.horizontalAlign = XlsxParagraphHelper.getHorizontalAlignment(align.getHorizontalAlignmentValue());
            this.verticalAlign = DocxCellHelper.getVerticalAlignment(align.getVerticalAlignmentValue());
        }
        this.isWrapText = isWrapText;
    }

    public String getId() {
        return this.fontIndex + "|" + this.borderIndex + "|" + this.backcolor + "|" + this.horizontalAlign + "|" + this.verticalAlign + "|" + this.isWrapText;
    }
}

