/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.base;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRVariable;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;
import net.sf.jasperreports.engine.type.CalculationEnum;
import net.sf.jasperreports.engine.type.IncrementTypeEnum;
import net.sf.jasperreports.engine.type.ResetTypeEnum;
import net.sf.jasperreports.engine.util.JRClassLoader;

public class JRBaseVariable
implements JRVariable,
Serializable {
    private static final long serialVersionUID = 10200L;
    protected String name;
    protected String valueClassName = String.class.getName();
    protected String valueClassRealName;
    protected String incrementerFactoryClassName;
    protected String incrementerFactoryClassRealName;
    protected ResetTypeEnum resetTypeValue = ResetTypeEnum.REPORT;
    protected IncrementTypeEnum incrementTypeValue = IncrementTypeEnum.NONE;
    protected CalculationEnum calculationValue = CalculationEnum.NOTHING;
    protected boolean isSystemDefined;
    protected transient Class valueClass;
    protected transient Class incrementerFactoryClass;
    protected JRExpression expression;
    protected JRExpression initialValueExpression;
    protected JRGroup resetGroup;
    protected JRGroup incrementGroup;
    private int PSEUDO_SERIAL_VERSION_UID = 30702;
    private byte resetType;
    private byte incrementType;
    private byte calculation;

    protected JRBaseVariable() {
    }

    protected JRBaseVariable(JRVariable variable, JRBaseObjectFactory factory) {
        factory.put(variable, this);
        this.name = variable.getName();
        this.valueClassName = variable.getValueClassName();
        this.incrementerFactoryClassName = variable.getIncrementerFactoryClassName();
        this.resetTypeValue = variable.getResetTypeValue();
        this.incrementTypeValue = variable.getIncrementTypeValue();
        this.calculationValue = variable.getCalculationValue();
        this.isSystemDefined = variable.isSystemDefined();
        this.expression = factory.getExpression(variable.getExpression());
        this.initialValueExpression = factory.getExpression(variable.getInitialValueExpression());
        this.resetGroup = factory.getGroup(variable.getResetGroup());
        this.incrementGroup = factory.getGroup(variable.getIncrementGroup());
    }

    public String getName() {
        return this.name;
    }

    public Class getValueClass() {
        String className;
        if (this.valueClass == null && (className = this.getValueClassRealName()) != null) {
            try {
                this.valueClass = JRClassLoader.loadClassForName(className);
            }
            catch (ClassNotFoundException e) {
                throw new JRRuntimeException(e);
            }
        }
        return this.valueClass;
    }

    public String getValueClassName() {
        return this.valueClassName;
    }

    private String getValueClassRealName() {
        if (this.valueClassRealName == null) {
            this.valueClassRealName = JRClassLoader.getClassRealName(this.valueClassName);
        }
        return this.valueClassRealName;
    }

    public Class getIncrementerFactoryClass() {
        String className;
        if (this.incrementerFactoryClass == null && (className = this.getIncrementerFactoryClassRealName()) != null) {
            try {
                this.incrementerFactoryClass = JRClassLoader.loadClassForName(className);
            }
            catch (ClassNotFoundException e) {
                throw new JRRuntimeException(e);
            }
        }
        return this.incrementerFactoryClass;
    }

    public String getIncrementerFactoryClassName() {
        return this.incrementerFactoryClassName;
    }

    private String getIncrementerFactoryClassRealName() {
        if (this.incrementerFactoryClassRealName == null) {
            this.incrementerFactoryClassRealName = JRClassLoader.getClassRealName(this.incrementerFactoryClassName);
        }
        return this.incrementerFactoryClassRealName;
    }

    public byte getResetType() {
        return this.getResetTypeValue().getValue();
    }

    public ResetTypeEnum getResetTypeValue() {
        return this.resetTypeValue;
    }

    public byte getIncrementType() {
        return this.getIncrementTypeValue().getValue();
    }

    public IncrementTypeEnum getIncrementTypeValue() {
        return this.incrementTypeValue;
    }

    public byte getCalculation() {
        return this.getCalculationValue().getValue();
    }

    public CalculationEnum getCalculationValue() {
        return this.calculationValue;
    }

    public boolean isSystemDefined() {
        return this.isSystemDefined;
    }

    public JRExpression getExpression() {
        return this.expression;
    }

    public JRExpression getInitialValueExpression() {
        return this.initialValueExpression;
    }

    public JRGroup getResetGroup() {
        return this.resetGroup;
    }

    public JRGroup getIncrementGroup() {
        return this.incrementGroup;
    }

    public Object clone() {
        JRBaseVariable clone = null;
        try {
            clone = (JRBaseVariable)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new JRRuntimeException(e);
        }
        if (this.expression != null) {
            clone.expression = (JRExpression)this.expression.clone();
        }
        if (this.initialValueExpression != null) {
            clone.initialValueExpression = (JRExpression)this.initialValueExpression.clone();
        }
        return clone;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.PSEUDO_SERIAL_VERSION_UID < 30702) {
            this.resetTypeValue = ResetTypeEnum.getByValue(this.resetType);
            this.incrementTypeValue = IncrementTypeEnum.getByValue(this.incrementType);
            this.calculationValue = CalculationEnum.getByValue(this.calculation);
        }
    }
}

