/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipInputStream;

class WordlistData {
    public long wordCount = 0L;
    public long wordsToLong = 0L;
    public long[] lenghts = new long[32];
    public long[] charCount = new long[256];
    public long maxLenght = 0L;

    public WordlistData() {
        int i = 0;
        while (i < this.lenghts.length) {
            this.lenghts[i] = 0L;
            ++i;
        }
        i = 0;
        while (i < this.charCount.length) {
            this.charCount[i] = 0L;
            ++i;
        }
    }

    public void CalculateDataFromFile(String fileName) throws IOException {
        String _ext = fileName.substring(fileName.lastIndexOf(46) + 1, fileName.length());
        InputStreamReader _inner_reader = null;
        if (_ext.equals("zip")) {
            _inner_reader = new InputStreamReader(new ZipInputStream(new FileInputStream(fileName)));
        } else if (_ext.equals("gz") || _ext.equals("tgz")) {
            _inner_reader = new InputStreamReader(new GZIPInputStream(new FileInputStream(fileName)));
        } else {
            if (_ext.equals("bz2") || _ext.equals("7z")) {
                return;
            }
            _inner_reader = new FileReader(fileName);
        }
        BufferedReader _reader = new BufferedReader(_inner_reader);
        String _line = _reader.readLine();
        while (_line != null) {
            if (_line.length() < this.lenghts.length) {
                int n = _line.length();
                this.lenghts[n] = this.lenghts[n] + 1L;
                ++this.wordCount;
                if ((long)_line.length() > this.maxLenght) {
                    this.maxLenght = _line.length();
                }
                int i = 0;
                while (i < _line.length()) {
                    if (_line.charAt(i) < this.charCount.length) {
                        char c = _line.charAt(i);
                        this.charCount[c] = this.charCount[c] + 1L;
                    }
                    ++i;
                }
            } else {
                ++this.wordsToLong;
            }
            _line = _reader.readLine();
        }
        _reader.close();
    }

    public void CalculateDataFromDB(String aQuery, Connection conn) throws SQLException {
        ResultSet _set = conn.prepareStatement(aQuery).executeQuery();
        while (_set.next()) {
            String _line = _set.getString(1);
            if (_line.length() < this.lenghts.length) {
                int n = _line.length();
                this.lenghts[n] = this.lenghts[n] + 1L;
                ++this.wordCount;
                if ((long)_line.length() > this.maxLenght) {
                    this.maxLenght = _line.length();
                }
                int i = 0;
                while (i < _line.length()) {
                    if (_line.charAt(i) < this.charCount.length) {
                        char c = _line.charAt(i);
                        this.charCount[c] = this.charCount[c] + 1L;
                    }
                    ++i;
                }
                continue;
            }
            ++this.wordsToLong;
        }
    }
}

