/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Map;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporter;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.export.JExcelApiExporter;
import net.sf.jasperreports.engine.export.JRCsvExporter;
import net.sf.jasperreports.engine.export.JRHtmlExporter;
import net.sf.jasperreports.engine.export.JRPdfExporter;
import net.sf.jasperreports.engine.export.JRPdfExporterParameter;
import net.sf.jasperreports.engine.export.JRRtfExporter;
import net.sf.jasperreports.engine.export.JRXhtmlExporter;
import net.sf.jasperreports.engine.export.JRXmlExporter;
import net.sf.jasperreports.engine.export.oasis.JROdsExporter;
import net.sf.jasperreports.engine.export.oasis.JROdtExporter;
import net.sf.jasperreports.engine.export.ooxml.JRDocxExporter;
import net.sf.jasperreports.engine.export.ooxml.JRPptxExporter;
import net.sf.jasperreports.engine.export.ooxml.JRXlsxExporter;
import net.sf.jasperreports.engine.util.JRLoader;
import org.sqlite.JDBC;

public class ReportAppMain {
    static ExportData[] outputData = new ExportData[]{new ExportData("pdf", "Portable Document Format.", (JRExporter)new JRPdfExporter()), new ExportData("htm", "To see in any web browser.", (JRExporter)new JRHtmlExporter()), new ExportData("html", "To see in any web browser.", (JRExporter)new JRXhtmlExporter()), new ExportData("docx", "Document Format used by Word 2007.", (JRExporter)new JRDocxExporter()), new ExportData("xls", "Microsoft Excel 2003 Format.", (JRExporter)new JExcelApiExporter()), new ExportData("xlsx", "Document Format used by Excel 2007.", (JRExporter)new JRXlsxExporter()), new ExportData("pptx", "Document Format used by PowerPoint 2007.", (JRExporter)new JRPptxExporter()), new ExportData("rtf", "RTF Format.", (JRExporter)new JRRtfExporter()), new ExportData("odt", "Open Document Format.", (JRExporter)new JROdtExporter()), new ExportData("ods", "Open Document Spreadsheet.", (JRExporter)new JROdsExporter()), new ExportData("csv", "Coma separeted values.", (JRExporter)new JRCsvExporter()), new ExportData("xml", "XML Format.", (JRExporter)new JRXmlExporter())};
    static String reportPath = ReportAppMain.getAppPath();
    static String reportExtension = ".jasper";
    public static String version = "Report Engine 1.0";

    public static void main(String[] args) throws JRException, IOException, SQLException {
        int reportName = -1;
        int outputName = -1;
        int db = -1;
        boolean needRegister = false;
        System.out.println("Hash Suite " + version);
        System.out.println("Copyright(c) 2011, Alain Espinosa");
        System.out.println();
        int i = 0;
        while (i < args.length) {
            if ("-register".equals(args[i])) {
                needRegister = true;
            } else if ("-output".equals(args[i])) {
                outputName = ++i;
            } else if ("-report".equals(args[i])) {
                reportName = ++i;
            } else if ("-db".equals(args[i])) {
                db = ++i;
            } else {
                ReportAppMain.printHelp();
            }
            ++i;
        }
        if (db < 1 || db >= args.length) {
            System.out.println("Error: No database file passed.");
            System.out.println();
            ReportAppMain.printHelp();
        }
        if (needRegister) {
            ReportAppMain.registerInDB(args[db]);
        }
        if (reportName < 1 || reportName >= args.length) {
            System.out.println("Error: No report name passed.");
            System.out.println();
            ReportAppMain.printHelp();
        }
        if (outputName < 1 || outputName >= args.length) {
            System.out.println("Error: No output name passed.");
            System.out.println();
            ReportAppMain.printHelp();
        }
        ReportAppMain.getReport(args[outputName], args[reportName], args[db]);
    }

    private static void printHelp() {
        System.out.println("The program accepts the following arguments:");
        System.out.print("-output <file_name>.<ext> where <ext> are one of: ");
        int i = 0;
        while (i < outputData.length) {
            System.out.print(ReportAppMain.outputData[i].extension);
            if (i != outputData.length - 1) {
                System.out.print(", ");
            }
            ++i;
        }
        System.out.println();
        System.out.println("-report <report_name> where <report_name> is a valid JasperReport(without .jasper) Report");
        System.out.println("-db <db_file> where <db_file> is a database file");
        System.exit(0);
    }

    private static void registerInDB(String dbPath) throws JRException {
        Connection conn = ReportAppMain.getDBConnection(dbPath);
        try {
            conn.prepareStatement("BEGIN TRANSACTION;").execute();
            PreparedStatement _insertExt = conn.prepareStatement("INSERT OR REPLACE INTO ReportFormats (ID, Format, Description) VALUES (?1, ?2 , ?3);");
            int i = 0;
            while (i < outputData.length) {
                _insertExt.clearParameters();
                _insertExt.setInt(1, i + 1);
                _insertExt.setString(2, ReportAppMain.outputData[i].extension);
                _insertExt.setString(3, ReportAppMain.outputData[i].description);
                _insertExt.execute();
                ++i;
            }
            File _reportDir = new File(reportPath);
            File[] _files = _reportDir.listFiles(new FileFilter(){

                @Override
                public boolean accept(File arg0) {
                    return arg0.exists() && arg0.isFile() && arg0.getName().endsWith(reportExtension);
                }
            });
            PreparedStatement _insertReports = conn.prepareStatement("INSERT OR REPLACE INTO Reports (ID, Name, Description) VALUES (?1, ?2 , ?3);");
            int i2 = 0;
            while (i2 < _files.length) {
                String name = _files[i2].getName();
                name = name.substring(0, name.length() - reportExtension.length());
                JasperReport jasperReport = (JasperReport)JRLoader.loadObject((File)_files[i2]);
                String _description = jasperReport.getProperty("com.hashsuit.report.description");
                String _visible = jasperReport.getProperty("com.hashsuit.report.visible");
                if (_visible != null && _visible.equals("yes")) {
                    _insertReports.clearParameters();
                    _insertReports.setInt(1, i2 + 1);
                    _insertReports.setString(2, name);
                    _insertReports.setString(3, _description == null ? name : _description);
                    _insertReports.execute();
                }
                ++i2;
            }
            conn.prepareStatement("END TRANSACTION;").execute();
        }
        catch (SQLException e) {
            System.out.print("Error: Problem accessing database.");
        }
        System.exit(0);
    }

    private static void getReport(String output, String reportName, String dbPath) throws JRException, IOException, SQLException {
        InfoDialog _infoGUI = new InfoDialog();
        File _reportFile = new File(String.valueOf(reportPath) + reportName + reportExtension);
        JRExporter _exporter = null;
        if (!_reportFile.exists()) {
            System.out.println("Error: No report with name '" + _reportFile.getName() + "' exist.");
            System.exit(0);
        }
        String _outputExt = output.substring(output.lastIndexOf(46) + 1, output.length());
        int i = 0;
        while (i < outputData.length) {
            if (ReportAppMain.outputData[i].extension.equals(_outputExt)) {
                _exporter = ReportAppMain.outputData[i].exporter;
            }
            ++i;
        }
        if (_exporter == null) {
            System.out.println("Error: No extension '" + _outputExt + "' recognized.");
            ReportAppMain.printHelp();
        }
        _infoGUI.ChangeStatus("Accessing Database...");
        Connection conn = ReportAppMain.getDBConnection(dbPath);
        _infoGUI.ChangeStatus("Loading report...");
        JasperReport _report = (JasperReport)JRLoader.loadObject((File)_reportFile);
        _infoGUI.ChangeStatus("Getting report parameters...");
        Map<String, Object> parameters = _infoGUI.getParameters(reportName, conn);
        _infoGUI.ChangeStatus("Filling report...");
        JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)_report, parameters, (Connection)conn);
        _infoGUI.ChangeStatus("Saving report...");
        _exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)jasperPrint);
        _exporter.setParameter(JRExporterParameter.OUTPUT_FILE_NAME, (Object)output);
        if (_outputExt.equals("pdf")) {
            _exporter.setParameter((JRExporterParameter)JRPdfExporterParameter.METADATA_TITLE, (Object)reportName);
            _exporter.setParameter((JRExporterParameter)JRPdfExporterParameter.METADATA_SUBJECT, (Object)_report.getProperty("com.hashsuit.report.description"));
            _exporter.setParameter((JRExporterParameter)JRPdfExporterParameter.METADATA_AUTHOR, (Object)"Automaticaly generated");
            _exporter.setParameter((JRExporterParameter)JRPdfExporterParameter.METADATA_CREATOR, (Object)("Hash Suite " + version));
        }
        _exporter.exportReport();
        Runtime.getRuntime().exec("explorer.exe " + output);
        System.exit(0);
    }

    public static String getAppPath() {
        String appPath = ReportAppMain.class.getProtectionDomain().getCodeSource().getLocation().getPath();
        appPath = (appPath = appPath.replaceAll("%20", " ")).endsWith(".jar") ? appPath.substring(0, appPath.length() - new File(appPath).getName().length()) : String.valueOf(appPath) + "../../../";
        return appPath;
    }

    private static Connection getDBConnection(String dbPath) {
        Connection conn = null;
        try {
            DriverManager.registerDriver((Driver)new JDBC());
            conn = DriverManager.getConnection("jdbc:sqlite://" + dbPath);
        }
        catch (SQLException ex) {
            System.out.println("Error: No database found.");
            System.exit(0);
        }
        return conn;
    }
}

