/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dialog;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.Point;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

class InfoDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private int status = 0;
    JLabel label;
    JProgressBar pb;

    public InfoDialog() throws SQLException {
        this.setLayout(new GridLayout(2, 1));
        this.setTitle("Report Generation Progress");
        this.setDefaultCloseOperation(0);
        this.setAlwaysOnTop(true);
        ImageIcon _icon = new ImageIcon(String.valueOf(ReportAppMain.getAppPath()) + "reportIcon.png");
        this.setIconImage(_icon.getImage());
        this.label = new JLabel("aaaaaaaaaaaaaaaaaaaaaaaaa");
        this.pb = new JProgressBar(0, 6);
        this.pb.setForeground(Color.BLUE);
        this.pb.setStringPainted(true);
        JPanel _panel = new JPanel();
        _panel.add(this.label);
        _panel.add(this.pb);
        this.add(_panel);
        this.pack();
        Point _centerPoint = GraphicsEnvironment.getLocalGraphicsEnvironment().getCenterPoint();
        this.setLocation(new Point(_centerPoint.x - this.getWidth() / 2, _centerPoint.y - this.getHeight() / 2));
        this.setVisible(true);
        this.label.setText("Generating report...");
    }

    public void ChangeStatus(String message) {
        ++this.status;
        this.label.setText(message);
        this.pb.setValue(this.status);
    }

    private JComboBox SelectChoosenParam(String aQuery, String aMessageChoose, Connection conn, MyDataChoosenFilter filter) throws SQLException {
        ResultSet _set = conn.prepareStatement(aQuery).executeQuery();
        JPanel _panel = new JPanel();
        JLabel _label = new JLabel(aMessageChoose);
        JComboBox<MyDataChoosen> _cbFormats = new JComboBox<MyDataChoosen>();
        JButton _bOk = new JButton("OK");
        _bOk.addActionListener(new CloseDialog(this));
        _cbFormats.addItem(new MyDataChoosen("-1", "All"));
        while (_set.next()) {
            MyDataChoosen _data = new MyDataChoosen(_set.getString(1), _set.getString(2));
            if (filter != null && !filter.filter(_data)) continue;
            _cbFormats.addItem(_data);
        }
        _panel.add(_label);
        _panel.add(_cbFormats);
        _panel.add(_bOk);
        this.add(_panel);
        this.pack();
        this.setVisible(false);
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.setVisible(true);
        this.remove(_panel);
        this.pack();
        return _cbFormats;
    }

    public Map<String, Object> getParameters(String reportName, Connection conn) throws SQLException, IOException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("EngineVersion", "Demo version generation, please purchase a licensed copy of Hash Suite");
        if (reportName.equals("Hashes_Found")) {
            MyDataChoosen _selFormat = (MyDataChoosen)this.SelectChoosenParam("SELECT ID,Name FROM Format;", "Choose one format", conn, null).getSelectedItem();
            int _ID = Integer.parseInt(_selFormat.dataNotShow);
            parameters.put("FormatName", _selFormat.dataShow);
            WordlistData _data = new WordlistData();
            if (_ID < 0) {
                parameters.put("FoundTotalQuery", "SELECT count(*) AS Num,'Found' AS Label FROM FindHash INNER JOIN Attack ON Attack.ID==FindHash.AttackUsed UNION SELECT count(*) AS Num,'Not Found' AS Label FROM Hash WHERE Hash.ID NOT IN (SELECT FindHash.ID FROM FindHash INNER JOIN Attack ON Attack.ID==FindHash.AttackUsed);");
                parameters.put("ByProviderQuery", "SELECT KeyProvider.Name AS KeyName,count(KeyProvider.Name) AS Total FROM FindHash INNER JOIN Attack ON Attack.ID==FindHash.AttackUsed INNER JOIN KeyProvider ON KeyProvider.ID==Attack.Provider GROUP BY KeyProvider.Name ORDER BY Total DESC;");
                _data.CalculateDataFromDB("SELECT ClearText FROM FindHash;", conn);
            } else {
                parameters.put("FoundTotalQuery", "SELECT count(*) AS Num,'Found' AS Label FROM FindHash INNER JOIN Attack ON Attack.ID==FindHash.AttackUsed WHERE Attack.Format==" + _ID + " UNION SELECT count(*) AS Num,'Not Found' AS Label FROM Hash WHERE Hash.Type==" + _ID + " AND Hash.ID NOT IN (SELECT FindHash.ID FROM FindHash INNER JOIN Attack ON Attack.ID==FindHash.AttackUsed WHERE Attack.Format==" + _ID + ");");
                parameters.put("ByProviderQuery", "SELECT KeyProvider.Name AS KeyName,count(KeyProvider.Name) AS Total FROM FindHash INNER JOIN Attack ON Attack.ID==FindHash.AttackUsed INNER JOIN KeyProvider ON KeyProvider.ID==Attack.Provider WHERE Attack.Format==" + _ID + " GROUP BY KeyProvider.Name ORDER BY Total DESC;");
                _data.CalculateDataFromDB("SELECT ClearText FROM Hash INNER JOIN FindHash ON Hash.ID==FindHash.ID WHERE Hash.Type==" + _ID + ";", conn);
            }
            parameters.put("com.hashsuit.FoundByTimeSource", new FoundByTimeSource(_ID, conn));
            parameters.put("com.hashsuit.WordlistLenghtSource", new WordlistLenghtSource(_data));
            parameters.put("com.hashsuit.WordlistByCharSource", new WordlistByCharSource(_data));
        } else if (reportName.equals("WordList")) {
            JComboBox _WordlistCombo = this.SelectChoosenParam("SELECT FileName,Name FROM WordList;", "Choose one wordlist", conn, new MyDataChoosenFilterFile());
            MyDataChoosen _selWordlist = (MyDataChoosen)_WordlistCombo.getSelectedItem();
            parameters.put("WordlistName", _selWordlist.dataShow);
            WordlistData _data = new WordlistData();
            if (_selWordlist.dataNotShow.equals("-1")) {
                int i = 1;
                while (i < _WordlistCombo.getItemCount()) {
                    _data.CalculateDataFromFile(((MyDataChoosen)_WordlistCombo.getItemAt((int)i)).dataNotShow);
                    ++i;
                }
            } else {
                _data.CalculateDataFromFile(_selWordlist.dataNotShow);
            }
            parameters.put("WordlistCount", _data.wordCount);
            parameters.put("com.hashsuit.WordlistLenghtSource", new WordlistLenghtSource(_data));
            parameters.put("com.hashsuit.WordlistByCharSource", new WordlistByCharSource(_data));
        }
        return parameters;
    }
}

